/*
 * Decompiled with CFR 0.152.
 */
package com.build_9.hyxin;

import com.build_9.hyxin.Constants;
import com.build_9.hyxin.LaunchEnvironment;
import com.build_9.hyxin.mixin.Bootstrap;
import com.build_9.hyxin.mixin.MixinService;
import com.build_9.hyxin.scanner.PluginManifest;
import com.build_9.hyxin.scanner.PluginScanner;
import com.hypixel.hytale.plugin.early.ClassTransformer;
import java.io.File;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;

public class HyxinTransformer
implements ClassTransformer {
    public HyxinTransformer() {
        LaunchEnvironment.create(this.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader());
        System.setProperty("java.util.logging.manager", "com.hypixel.hytale.logger.backend.HytaleLogManager");
        System.setProperty("mixin.bootstrapService", Bootstrap.class.getName());
        System.setProperty("mixin.service", MixinService.class.getName());
        PluginScanner plugins = new PluginScanner();
        plugins.scanDirectory(new File("./earlyplugins"));
        MixinBootstrap.init();
        for (Map.Entry<File, PluginManifest> entry : plugins.entries().entrySet()) {
            if (!entry.getValue().hasMixinConfigs()) continue;
            for (String config : entry.getValue().hyxin().configs()) {
                Constants.log("Loading Mixin config '" + config + "' from '" + entry.getKey().getName() + "'");
                Mixins.addConfiguration(config);
            }
        }
    }

    private void setupRuntimeEnvironment() {
        LaunchEnvironment.get().captureRuntimeLoader(Thread.currentThread().getContextClassLoader());
        MixinService.changePhase(MixinEnvironment.Phase.INIT);
        MixinService.changePhase(MixinEnvironment.Phase.DEFAULT);
    }

    public int priority() {
        return -100;
    }

    @Nullable
    public byte[] transform(@Nonnull String name, @Nonnull String path, @Nonnull byte[] bytes) {
        if (LaunchEnvironment.get().getRuntimeLoader() == null) {
            this.setupRuntimeEnvironment();
        }
        return MixinService.transformer.transformClassBytes(name, name, bytes);
    }
}

