/*
 * Decompiled with CFR 0.152.
 */
package com.build_9.hyxin;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.ClassReader;

public class LaunchEnvironment {
    private static LaunchEnvironment instance;
    private final ClassLoader systemLoader;
    private final ClassLoader earlyPluginLoader;
    private ClassLoader runtimeLoader;

    private LaunchEnvironment(ClassLoader earlyPluginLoader, ClassLoader systemLoader) {
        this.systemLoader = systemLoader;
        this.earlyPluginLoader = earlyPluginLoader;
    }

    public static LaunchEnvironment get() {
        if (instance == null) {
            throw new IllegalStateException("Can not access LaunchEnvironment before it has been created.");
        }
        return instance;
    }

    public static void create(ClassLoader systemLoader, ClassLoader earlyPluginLoader) {
        if (instance != null) {
            throw new IllegalStateException("LaunchEnvironment has already been created!");
        }
        instance = new LaunchEnvironment(systemLoader, earlyPluginLoader);
    }

    public void captureRuntimeLoader(ClassLoader loader) {
        if (this.runtimeLoader != null) {
            throw new IllegalStateException("Runtime ClassLoader has already been captured! '" + String.valueOf(this.runtimeLoader) + "'");
        }
        this.runtimeLoader = loader;
    }

    public ClassLoader getSystemLoader() {
        return this.systemLoader;
    }

    public ClassLoader getEarlyPluginLoader() {
        return this.earlyPluginLoader;
    }

    public ClassLoader getRuntimeLoader() {
        return this.runtimeLoader;
    }

    public ClassLoader findLoaderForClass(String resourceName) throws ClassNotFoundException {
        try {
            return this.findLoaderFor(resourceName.replace(".", "/").concat(".class"));
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Could not find class '" + resourceName + "'.", e);
        }
    }

    public ClassLoader findLoaderFor(String resourceName) throws IOException {
        if (this.runtimeLoader != null && this.runtimeLoader.getResource(resourceName) != null) {
            return this.runtimeLoader;
        }
        if (this.earlyPluginLoader != null && this.earlyPluginLoader.getResource(resourceName) != null) {
            return this.earlyPluginLoader;
        }
        if (this.systemLoader != null && this.systemLoader.getResource(resourceName) != null) {
            return this.systemLoader;
        }
        throw new FileNotFoundException("Could not find resource '" + resourceName + "' on any class loader.");
    }

    public InputStream findResourceStream(String resourceName) throws IOException {
        return this.findLoaderFor(resourceName).getResourceAsStream(resourceName);
    }

    public ClassReader getClassReader(String name) throws IOException, ClassNotFoundException {
        String fileName = name.replace(".", "/").concat(".class");
        try (InputStream stream = this.findResourceStream(fileName);){
            if (stream != null) {
                ClassReader classReader = new ClassReader(stream);
                return classReader;
            }
        }
        throw new ClassNotFoundException("Could not find class '" + fileName + "'.");
    }
}

