/*
 * Decompiled with CFR 0.152.
 */
package com.build_9.hyxin.scanner;

import com.build_9.hyxin.Constants;
import com.build_9.hyxin.scanner.PluginManifest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PluginScanner {
    private static final Gson GSON = new GsonBuilder().create();
    private final Map<File, PluginManifest> manifests = new HashMap<File, PluginManifest>();

    public void scanDirectory(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Can not load plugins from '" + dir.getAbsolutePath() + "'. It is not a directory!");
        }
        Constants.log("Scanning for plugins in '" + dir.getAbsolutePath() + "'.");
        for (File candidate : Objects.requireNonNull(dir.listFiles())) {
            Constants.log("Encounter file: '" + candidate.getName() + "'.");
            if (!candidate.isFile() || !candidate.getName().toLowerCase(Locale.ROOT).endsWith(".jar")) continue;
            try {
                PluginManifest manifest = PluginScanner.readManifest(candidate);
                if (manifest == null) continue;
                this.manifests.put(candidate, manifest);
                Constants.log("Find potential target '" + candidate.getName() + "'.");
            }
            catch (IOException e) {
                System.err.println("[Hyxin] Encountered an error when scanning '" + candidate.getPath() + "'.");
                e.printStackTrace(System.err);
            }
        }
        Constants.log("Scanning for plugins in '" + dir.getAbsolutePath() + "' end.");
    }

    public static PluginManifest readManifest(File jarFile) throws IOException {
        block10: {
            try (JarFile jar = new JarFile(jarFile);){
                PluginManifest pluginManifest;
                JarEntry entry = jar.getJarEntry("manifest.json");
                if (entry == null) break block10;
                try (InputStreamReader reader = new InputStreamReader(jar.getInputStream(entry));){
                    pluginManifest = (PluginManifest)GSON.fromJson((Reader)reader, PluginManifest.class);
                }
                return pluginManifest;
            }
        }
        return null;
    }

    public Map<File, PluginManifest> entries() {
        return Collections.unmodifiableMap(this.manifests);
    }
}

