/*
 * Decompiled with CFR 0.152.
 */
package com.build_9.hyxin.impl.mixins;

import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.RemoveReason;
import com.hypixel.hytale.component.ResourceType;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.entity.UUIDComponent;
import com.hypixel.hytale.server.core.entity.reference.InvalidatablePersistentRef;
import com.hypixel.hytale.server.core.modules.time.WorldTimeResource;
import com.hypixel.hytale.server.flock.StoredFlock;
import com.hypixel.hytale.server.npc.components.SpawnMarkerReference;
import com.hypixel.hytale.server.npc.systems.SpawnReferenceSystems;
import com.hypixel.hytale.server.spawning.assets.spawnmarker.config.SpawnMarker;
import com.hypixel.hytale.server.spawning.spawnmarkers.SpawnMarkerEntity;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SpawnReferenceSystems.MarkerAddRemoveSystem.class}, remap=false)
public class SpawnReferenceSystemsMixin {
    @Unique
    private static final HytaleLogger LOGGER = HytaleLogger.get((String)"SpawnReferenceSystemsMixin");
    @Unique
    private static boolean loggedInit = false;
    @Shadow
    @Final
    @Nonnull
    private ComponentType spawnReferenceComponentType;
    @Shadow
    @Final
    @Nonnull
    private ComponentType spawnMarkerEntityComponentType;
    @Shadow
    @Final
    @Nonnull
    private ComponentType uuidComponentComponentType;
    @Shadow
    @Final
    @Nonnull
    private ResourceType worldTimeResourceResourceType;

    @Overwrite
    public void onEntityRemove(@Nonnull Ref ref, @Nonnull RemoveReason removeReason, @Nonnull Store store, @Nonnull CommandBuffer commandBuffer) {
        if (!loggedInit) {
            LOGGER.at(Level.INFO).log("[SpawnReferenceSystemsMixin] Mixin actif - protection NullPointerException activee!");
            loggedInit = true;
        }
        switch (removeReason) {
            case REMOVE: {
                try {
                    Object object;
                    WorldTimeResource worldTimeResource;
                    SpawnMarkerReference spawnMarkerReference = (SpawnMarkerReference)store.getComponent(ref, this.spawnReferenceComponentType);
                    if (spawnMarkerReference == null) {
                        return;
                    }
                    Ref ref2 = spawnMarkerReference.getReference().getEntity((ComponentAccessor)store);
                    if (ref2 == null) {
                        return;
                    }
                    SpawnMarkerEntity spawnMarkerEntity = (SpawnMarkerEntity)store.getComponent(ref2, this.spawnMarkerEntityComponentType);
                    if (spawnMarkerEntity == null) {
                        LOGGER.at(Level.WARNING).log("[SpawnReferenceSystemsMixin] spawnMarkerComponent null - crash evite!");
                        return;
                    }
                    UUIDComponent uUIDComponent = (UUIDComponent)store.getComponent(ref, this.uuidComponentComponentType);
                    if (uUIDComponent == null) {
                        LOGGER.at(Level.WARNING).log("[SpawnReferenceSystemsMixin] uuidComponent null - crash evite!");
                        return;
                    }
                    UUID uUID = uUIDComponent.getUuid();
                    int n = spawnMarkerEntity.decrementAndGetSpawnCount();
                    SpawnMarker spawnMarker = spawnMarkerEntity.getCachedMarker();
                    if (spawnMarker == null) {
                        LOGGER.at(Level.WARNING).log("[SpawnReferenceSystemsMixin] cachedMarker null - crash evite!");
                        return;
                    }
                    if (n > 0 && spawnMarker.getDeactivationDistance() > 0.0) {
                        worldTimeResource = new InvalidatablePersistentRef[n];
                        int n2 = 0;
                        object = spawnMarkerEntity.getNpcReferences();
                        if (object == null) {
                            LOGGER.at(Level.WARNING).log("[SpawnReferenceSystemsMixin] npcReferences null detecte - crash evite!");
                        } else {
                            for (InvalidatablePersistentRef invalidatablePersistentRef : object) {
                                if (invalidatablePersistentRef == null || invalidatablePersistentRef.getUuid().equals(uUID) || n2 >= ((WorldTimeResource)worldTimeResource).length) continue;
                                worldTimeResource[n2++] = invalidatablePersistentRef;
                            }
                            spawnMarkerEntity.setNpcReferences((InvalidatablePersistentRef[])worldTimeResource);
                        }
                    }
                    if (n > 0 || spawnMarker.isRealtimeRespawn()) break;
                    worldTimeResource = (WorldTimeResource)store.getResource(this.worldTimeResourceResourceType);
                    if (worldTimeResource == null) {
                        return;
                    }
                    Instant instant = worldTimeResource.getGameTime();
                    object = spawnMarkerEntity.pollGameTimeRespawn();
                    if (object != null) {
                        instant = instant.plus((TemporalAmount)object);
                    }
                    spawnMarkerEntity.setSpawnAfter(instant);
                    spawnMarkerEntity.setNpcReferences((InvalidatablePersistentRef[])null);
                    StoredFlock storedFlock = spawnMarkerEntity.getStoredFlock();
                    if (storedFlock == null) break;
                    storedFlock.clear();
                }
                catch (Exception exception) {
                    LOGGER.at(Level.SEVERE).log("[SpawnReferenceSystemsMixin] Exception attrapee - crash evite! " + exception.getMessage());
                }
                break;
            }
        }
    }

    static {
        System.out.println("[SpawnReferenceSystemsMixin] Mixin charge avec succes! Protection NullPointerException pour MarkerAddRemoveSystem activee.");
    }
}

