/*
 * Decompiled with CFR 0.152.
 */
package dev.sthorne.hytale.plugins.quickstacker;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.protocol.packets.interface_.Page;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.windows.ContainerWindow;
import com.hypixel.hytale.server.core.entity.entities.player.windows.Window;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.container.CombinedItemContainer;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.chunk.WorldChunk;
import com.hypixel.hytale.server.core.universe.world.meta.BlockState;
import com.hypixel.hytale.server.core.universe.world.meta.state.ItemContainerState;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import dev.sthorne.hytale.plugins.quickstacker.PluginConfig;
import dev.sthorne.hytale.plugins.quickstacker.Utils;
import java.util.HashSet;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class BrowseNearbyCommand
extends AbstractPlayerCommand {
    private final Config<PluginConfig> Config;

    public BrowseNearbyCommand(Config<PluginConfig> config) {
        super("browse", "Allows the player to browse all nearby chests at once.");
        this.Config = config;
        this.setPermissionGroup(GameMode.Adventure);
    }

    protected void execute(@NonNullDecl CommandContext commandContext, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!commandContext.isPlayer()) {
            return;
        }
        Player srcPlayer = (Player)commandContext.sender();
        CombinedItemContainer inv = this.GetCombinedInventory(srcPlayer);
        if (inv != null) {
            srcPlayer.getPageManager().setPageWithWindows(ref, store, Page.Inventory, true, new Window[]{new ContainerWindow((ItemContainer)inv)});
        }
    }

    protected CombinedItemContainer GetCombinedInventory(Player player) {
        World world = player.getWorld();
        if (world == null) {
            return null;
        }
        TransformComponent transform = Utils.GetPlayerTransform(player);
        if (transform == null) {
            return null;
        }
        int posX = (int)transform.getPosition().x;
        int posY = (int)transform.getPosition().y;
        int posZ = (int)transform.getPosition().z;
        Inventory inventory = player.getInventory();
        if (inventory == null) {
            return null;
        }
        int maxRadius = ((PluginConfig)this.Config.get()).GetStackToChestRange();
        HashSet<ItemContainer> containers = new HashSet<ItemContainer>();
        for (int x = posX - maxRadius; x < posX + maxRadius; ++x) {
            for (int y = posY - maxRadius; y < posY + maxRadius; ++y) {
                for (int z = posZ - maxRadius; z < posZ + maxRadius; ++z) {
                    BlockState blockState;
                    WorldChunk chunk = world.getChunk(ChunkUtil.indexChunkFromBlock((int)x, (int)z));
                    if (chunk == null || !((blockState = chunk.getState(x, y, z)) instanceof ItemContainerState)) continue;
                    ItemContainerState containerState = (ItemContainerState)blockState;
                    int dx = posX - x;
                    int dy = posY - y;
                    int dz = posZ - z;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (distance > (double)maxRadius) continue;
                    containers.add(containerState.getItemContainer());
                }
            }
        }
        if (containers.isEmpty()) {
            return null;
        }
        return new CombinedItemContainer(containers.toArray(new ItemContainer[0]));
    }
}

