/*
 * Decompiled with CFR 0.152.
 */
package dev.sthorne.hytale.plugins.quickstacker;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.inventory.transaction.ItemStackTransaction;
import com.hypixel.hytale.server.core.inventory.transaction.ListTransaction;
import com.hypixel.hytale.server.core.inventory.transaction.MoveTransaction;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.chunk.WorldChunk;
import com.hypixel.hytale.server.core.universe.world.meta.BlockState;
import com.hypixel.hytale.server.core.universe.world.meta.state.ItemContainerState;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import dev.sthorne.hytale.plugins.quickstacker.Plugin;
import dev.sthorne.hytale.plugins.quickstacker.PluginConfig;
import dev.sthorne.hytale.plugins.quickstacker.Utils;
import java.awt.Color;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class StackToNearbyCommand
extends AbstractPlayerCommand {
    private final Config<PluginConfig> Config;

    public StackToNearbyCommand(Config<PluginConfig> config) {
        super("stack", "Quick stack to all nearby chests.\n\n/stack is deprecated and will be removed, please use one of the other aliases.");
        this.addAliases(new String[]{"cheststack", "cstack", "stackchest", "stackc"});
        this.Config = config;
        this.setPermissionGroup(GameMode.Adventure);
    }

    protected void execute(@NonNullDecl CommandContext commandContext, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!commandContext.isPlayer()) {
            return;
        }
        if (!commandContext.getInputString().equalsIgnoreCase("quickstack") && !commandContext.getInputString().equalsIgnoreCase("qs")) {
            Message deprecationMessage = Message.raw((String)("/" + commandContext.getInputString() + " is deprecated and will be removed. Please use the /qs or /quickstack command."));
            deprecationMessage.color(Color.YELLOW);
            commandContext.sendMessage(deprecationMessage);
        }
        Player srcPlayer = (Player)commandContext.sender();
        StackToNearbyCommand.quickStackToNearbyChests(srcPlayer);
    }

    public static void quickStackToNearbyChests(Player player) {
        World world = player.getWorld();
        if (world == null) {
            return;
        }
        TransformComponent transform = Utils.GetPlayerTransform(player);
        if (transform == null) {
            return;
        }
        int posX = (int)transform.getPosition().x;
        int posY = (int)transform.getPosition().y;
        int posZ = (int)transform.getPosition().z;
        Inventory inventory = player.getInventory();
        if (inventory == null) {
            return;
        }
        int availableChests = 0;
        int chestCount = 0;
        int itemCount = 0;
        int maxRadius = ((PluginConfig)Plugin.Config.get()).GetStackToChestRange();
        for (int x = posX - maxRadius; x < posX + maxRadius; ++x) {
            for (int y = posY - maxRadius; y < posY + maxRadius; ++y) {
                for (int z = posZ - maxRadius; z < posZ + maxRadius; ++z) {
                    BlockState blockState;
                    WorldChunk chunk = world.getChunk(ChunkUtil.indexChunkFromBlock((int)x, (int)z));
                    if (chunk == null || !((blockState = chunk.getState(x, y, z)) instanceof ItemContainerState)) continue;
                    ItemContainerState containerState = (ItemContainerState)blockState;
                    int dx = posX - x;
                    int dy = posY - y;
                    int dz = posZ - z;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (distance > (double)maxRadius) continue;
                    ListTransaction transaction = ((PluginConfig)Plugin.Config.get()).GetIncludeHotbar() ? inventory.getCombinedHotbarFirst().quickStackTo(new ItemContainer[]{containerState.getItemContainer()}) : inventory.getStorage().quickStackTo(new ItemContainer[]{containerState.getItemContainer()});
                    int change = Utils.GetMovedItemQuantityFromTransaction((ListTransaction<MoveTransaction<ItemStackTransaction>>)transaction);
                    if (change > 0) {
                        ++chestCount;
                    }
                    itemCount += change;
                    ++availableChests;
                }
            }
        }
        if (availableChests <= 0) {
            player.sendMessage(Message.raw((String)"There are no nearby chests."));
        } else if (itemCount > 0) {
            player.sendMessage(Message.raw((String)("Successfully quick stacked " + itemCount + " items to " + chestCount + " nearby chests.")));
        } else {
            player.sendMessage(Message.raw((String)"No items capable of being quick stacked."));
        }
    }
}

