/*
 * Decompiled with CFR 0.152.
 */
package dev.sthorne.hytale.plugins.quickstacker;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.inventory.transaction.ItemStackTransaction;
import com.hypixel.hytale.server.core.inventory.transaction.ListTransaction;
import com.hypixel.hytale.server.core.inventory.transaction.MoveTransaction;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.Config;
import dev.sthorne.hytale.plugins.quickstacker.PluginConfig;
import dev.sthorne.hytale.plugins.quickstacker.Utils;
import java.awt.Color;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class StackToPlayerCommand
extends AbstractPlayerCommand {
    private static final Message MESSAGE_COMMANDS_ERRORS_UNKNOWN_ERROR = Message.raw((String)"An unknown error has occurred.");
    private final Config<PluginConfig> Config;
    private final RequiredArg<PlayerRef> Argument;

    public StackToPlayerCommand(Config<PluginConfig> config) {
        this(config, false);
    }

    public StackToPlayerCommand(Config<PluginConfig> config, boolean deprecated) {
        String name = deprecated ? "playerstack" : "player";
        super(name, "Quick stack to a nearby player.");
        this.Config = config;
        if (deprecated) {
            this.addAliases(new String[]{"pstack", "stackplayer", "stackp"});
        }
        this.Argument = this.withRequiredArg("p", "Quick stacks to this player's inventory if nearby.", (ArgumentType)ArgTypes.PLAYER_REF);
        this.setPermissionGroup(GameMode.Adventure);
    }

    protected void execute(@NonNullDecl CommandContext commandContext, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!commandContext.isPlayer()) {
            return;
        }
        if (!commandContext.getInputString().toLowerCase().startsWith("quickstack") && !commandContext.getInputString().toLowerCase().startsWith("qs")) {
            Message deprecationMessage = Message.raw((String)("/" + commandContext.getInputString() + " is deprecated and will be removed. Please use the /qs or /quickstack command."));
            deprecationMessage.color(Color.YELLOW);
            commandContext.sendMessage(deprecationMessage);
        }
        Player srcPlayer = (Player)commandContext.sender();
        PlayerRef targetPlayerRef = (PlayerRef)commandContext.get(this.Argument);
        if (targetPlayerRef == null) {
            return;
        }
        Player targetPlayer = Utils.GetPlayerFromRef(targetPlayerRef);
        if (targetPlayer == null) {
            commandContext.sendMessage(Message.translation((String)"server.commands.errors.playerNotInWorld"));
            return;
        }
        Message result = this.quickStackToNearbyPlayer(srcPlayer, targetPlayer);
        if (result != null) {
            commandContext.sendMessage(result);
        }
    }

    protected Message quickStackToNearbyPlayer(Player src, Player target) {
        double dz;
        double dy;
        double dx;
        double distance;
        World srcWorld = src.getWorld();
        World targetWorld = target.getWorld();
        if (srcWorld == null || targetWorld == null) {
            return MESSAGE_COMMANDS_ERRORS_UNKNOWN_ERROR;
        }
        if (!srcWorld.equals((Object)targetWorld)) {
            return MESSAGE_COMMANDS_ERRORS_UNKNOWN_ERROR;
        }
        TransformComponent srcTransform = Utils.GetPlayerTransform(src);
        TransformComponent targetTransform = Utils.GetPlayerTransform(target);
        if (srcTransform == null || targetTransform == null) {
            return MESSAGE_COMMANDS_ERRORS_UNKNOWN_ERROR;
        }
        Inventory srcInv = src.getInventory();
        Inventory targetInv = target.getInventory();
        if (srcInv == null || targetInv == null) {
            return MESSAGE_COMMANDS_ERRORS_UNKNOWN_ERROR;
        }
        Vector3d srcPos = srcTransform.getPosition();
        Vector3d targetPos = targetTransform.getPosition();
        int maxRadius = ((PluginConfig)this.Config.get()).GetStackToPlayerRange();
        if (maxRadius > 0 && (distance = Math.sqrt((dx = srcPos.x - targetPos.x) * dx + (dy = srcPos.y - targetPos.y) * dy + (dz = srcPos.z - targetPos.z) * dz)) > (double)((PluginConfig)this.Config.get()).GetStackToPlayerRange()) {
            return Message.raw((String)"Target player is too far.");
        }
        ListTransaction transaction = ((PluginConfig)this.Config.get()).GetIncludeHotbar() ? srcInv.getCombinedHotbarFirst().quickStackTo(new ItemContainer[]{targetInv.getCombinedHotbarFirst()}) : srcInv.getStorage().quickStackTo(new ItemContainer[]{targetInv.getCombinedHotbarFirst()});
        int itemCount = Utils.GetMovedItemQuantityFromTransaction((ListTransaction<MoveTransaction<ItemStackTransaction>>)transaction);
        if (itemCount > 0) {
            target.sendMessage(Message.raw((String)(src.getDisplayName() + " quick stacked " + itemCount + " items to your inventory.")));
            return Message.raw((String)("Successfully quick stacked " + itemCount + " items to " + target.getDisplayName() + "'s inventory."));
        }
        return Message.raw((String)"No items capable of being quick stacked.");
    }
}

