/*
 * Decompiled with CFR 0.152.
 */
package dev.sthorne.hytale.plugins.quickstacker;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.transaction.ItemStackSlotTransaction;
import com.hypixel.hytale.server.core.inventory.transaction.ItemStackTransaction;
import com.hypixel.hytale.server.core.inventory.transaction.ListTransaction;
import com.hypixel.hytale.server.core.inventory.transaction.MoveTransaction;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;

public class Utils {
    public static TransformComponent GetPlayerTransform(Player player) {
        Ref playerRef = player.getReference();
        World world = player.getWorld();
        if (world == null || playerRef == null) {
            return null;
        }
        Store store = world.getEntityStore().getStore();
        return (TransformComponent)store.getComponent(playerRef, TransformComponent.getComponentType());
    }

    public static Player GetPlayerFromRef(PlayerRef playerRef) {
        Ref ref = playerRef.getReference();
        if (ref == null) {
            return null;
        }
        Store store = ref.getStore();
        return (Player)store.getComponent(ref, Player.getComponentType());
    }

    public static int GetMovedItemQuantityFromTransaction(ListTransaction<MoveTransaction<ItemStackTransaction>> transaction) {
        int itemCount = 0;
        if (transaction.succeeded()) {
            for (MoveTransaction t : transaction.getList()) {
                if (!t.succeeded() || !((ItemStackTransaction)t.getAddTransaction()).succeeded()) continue;
                for (ItemStackSlotTransaction st : ((ItemStackTransaction)t.getAddTransaction()).getSlotTransactions()) {
                    if (!st.succeeded()) continue;
                    ItemStack before = st.getSlotBefore();
                    ItemStack after = st.getSlotAfter();
                    itemCount += (after == null ? 0 : after.getQuantity()) - (before == null ? 0 : before.getQuantity());
                }
            }
        }
        return itemCount;
    }
}

