/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.SpongeTimingsFactory;
import co.aikar.timings.TimingHandler;
import co.aikar.timings.TimingHistory;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.TimingsManager;
import co.aikar.timings.TimingsPls;
import co.aikar.timings.TimingsReportListener;
import co.aikar.util.JSONUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.source.RconSource;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.common.SpongeImpl;

class TimingsExport
extends Thread {
    private static final Joiner AUTHOR_LIST_JOINER = Joiner.on((String)", ");
    private static final Joiner RUNTIME_FLAG_JOINER = Joiner.on((String)" ");
    private static final Joiner CONFIG_PATH_JOINER = Joiner.on((String)".");
    private final TimingsReportListener listeners;
    private final JsonObject out;
    private final TimingHistory[] history;
    private static long lastReport = 0L;
    static final List<MessageChannel> requestingReport = Lists.newArrayList();

    TimingsExport(TimingsReportListener listeners, JsonObject out, TimingHistory[] history) {
        super("Timings paste thread");
        this.listeners = listeners;
        this.out = out;
        this.history = history;
    }

    private static String getServerName() {
        return SpongeImpl.getPlugin().getName() + " " + SpongeImpl.getPlugin().getVersion().orElse("");
    }

    static void reportTimings() {
        if (requestingReport.isEmpty()) {
            return;
        }
        TimingsReportListener listeners = new TimingsReportListener(requestingReport);
        requestingReport.clear();
        long now = System.currentTimeMillis();
        long lastReportDiff = now - lastReport;
        if (lastReportDiff < 60000L) {
            listeners.send(Text.of(TextColors.RED, "Please wait at least 1 minute in between Timings reports. (" + (int)((60000L - lastReportDiff) / 1000L) + " seconds)"));
            listeners.done();
            return;
        }
        long lastStartDiff = now - TimingsManager.timingStart;
        if (lastStartDiff < 180000L) {
            listeners.send(Text.of(TextColors.RED, "Please wait at least 3 minutes before generating a Timings report. Unlike Timings v1, v2 benefits from longer timings and is not as useful with short timings. (" + (int)((180000L - lastStartDiff) / 1000L) + " seconds)"));
            listeners.done();
            return;
        }
        listeners.send(Text.of(TextColors.GREEN, "Preparing Timings Report..."));
        lastReport = now;
        Platform platform = SpongeImpl.getGame().getPlatform();
        JSONUtil.JsonObjectBuilder builder = JSONUtil.objectBuilder().add("version", (Object)platform.getContainer(Platform.Component.IMPLEMENTATION).getVersion().orElse(platform.getMinecraftVersion().getName() + "-DEV")).add("maxplayers", (Object)SpongeImpl.getGame().getServer().getMaxPlayers()).add("start", (Object)(TimingsManager.timingStart / 1000L)).add("end", (Object)(System.currentTimeMillis() / 1000L)).add("sampletime", (Object)((System.currentTimeMillis() - TimingsManager.timingStart) / 1000L));
        if (!TimingsManager.privacy) {
            builder.add("server", (Object)TimingsExport.getServerName()).add("motd", (Object)Sponge.getServer().getMotd().toPlain()).add("online-mode", (Object)Sponge.getServer().getOnlineMode()).add("icon", (Object)SpongeImpl.getServer().func_147134_at().func_151316_d());
        }
        Runtime runtime = Runtime.getRuntime();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        builder.add("system", (Object)JSONUtil.objectBuilder().add("timingcost", (Object)TimingsExport.getCost()).add("name", (Object)System.getProperty("os.name")).add("version", (Object)System.getProperty("os.version")).add("jvmversion", (Object)System.getProperty("java.version")).add("arch", (Object)System.getProperty("os.arch")).add("maxmem", (Object)runtime.maxMemory()).add("cpu", (Object)runtime.availableProcessors()).add("runtime", (Object)ManagementFactory.getRuntimeMXBean().getUptime()).add("flags", (Object)RUNTIME_FLAG_JOINER.join(runtimeBean.getInputArguments())).add("gc", (Object)JSONUtil.mapArrayToObject(ManagementFactory.getGarbageCollectorMXBeans(), input -> JSONUtil.singleObjectPair(input.getName(), (Object)JSONUtil.arrayOf(input.getCollectionCount(), input.getCollectionTime())))));
        HashSet tileEntityTypeSet = Sets.newHashSet();
        HashSet entityTypeSet = Sets.newHashSet();
        int size = TimingsManager.HISTORY.size();
        TimingHistory[] history = new TimingHistory[size + 1];
        int i = 0;
        for (TimingHistory timingHistory : TimingsManager.HISTORY) {
            tileEntityTypeSet.addAll(timingHistory.tileEntityTypeSet);
            entityTypeSet.addAll(timingHistory.entityTypeSet);
            history[i++] = timingHistory;
        }
        history[i] = new TimingHistory();
        tileEntityTypeSet.addAll(history[i].tileEntityTypeSet);
        entityTypeSet.addAll(history[i].entityTypeSet);
        JSONUtil.JsonObjectBuilder handlersBuilder = JSONUtil.objectBuilder();
        for (TimingIdentifier.TimingGroup group2 : TimingIdentifier.GROUP_MAP.values()) {
            for (TimingHandler id : group2.handlers) {
                if (!id.timed && !id.isSpecial()) continue;
                handlersBuilder.add(id.id, (Object)JSONUtil.arrayOf(group2.id, id.name));
            }
        }
        builder.add("idmap", (Object)JSONUtil.objectBuilder().add("groups", (Object)JSONUtil.mapArrayToObject(TimingIdentifier.GROUP_MAP.values(), group -> JSONUtil.singleObjectPair(group.id, (Object)group.name))).add("handlers", (Object)handlersBuilder).add("worlds", (Object)JSONUtil.mapArrayToObject(TimingHistory.worldMap.entrySet(), entry -> JSONUtil.singleObjectPair((Integer)entry.getValue(), entry.getKey()))).add("tileentity", (Object)JSONUtil.mapArrayToObject(tileEntityTypeSet, tileEntityType -> JSONUtil.singleObjectPair(TimingsPls.getTileEntityId(tileEntityType), (Object)tileEntityType.getName()))).add("entity", (Object)JSONUtil.mapArrayToObject(entityTypeSet, entityType -> {
            if (entityType == EntityTypes.UNKNOWN) {
                return null;
            }
            return JSONUtil.singleObjectPair(TimingsPls.getEntityId(entityType), (Object)entityType.getId());
        })));
        builder.add("plugins", (Object)JSONUtil.mapArrayToObject(SpongeImpl.getGame().getPluginManager().getPlugins(), plugin -> JSONUtil.objectBuilder().add(plugin.getId(), (Object)JSONUtil.objectBuilder().add("version", (Object)plugin.getVersion().orElse("")).add("description", (Object)plugin.getDescription().orElse("")).add("website", (Object)plugin.getUrl().orElse("")).add("authors", (Object)AUTHOR_LIST_JOINER.join(plugin.getAuthors()))).build()));
        builder.add("config", (Object)JSONUtil.objectBuilder().add("sponge", (Object)TimingsExport.serializeConfigNode(SpongeImpl.getGlobalConfig().getRootNode())));
        new TimingsExport(listeners, builder.build(), history).start();
    }

    static long getCost() {
        int passes = 200;
        TimingHandler SAMPLER1 = SpongeTimingsFactory.ofSafe("Timings Sampler 1");
        TimingHandler SAMPLER2 = SpongeTimingsFactory.ofSafe("Timings Sampler 2");
        TimingHandler SAMPLER3 = SpongeTimingsFactory.ofSafe("Timings Sampler 3");
        TimingHandler SAMPLER4 = SpongeTimingsFactory.ofSafe("Timings Sampler 4");
        TimingHandler SAMPLER5 = SpongeTimingsFactory.ofSafe("Timings Sampler 5");
        TimingHandler SAMPLER6 = SpongeTimingsFactory.ofSafe("Timings Sampler 6");
        long start = System.nanoTime();
        for (int i = 0; i < passes; ++i) {
            SAMPLER1.startTiming();
            SAMPLER2.startTiming();
            SAMPLER3.startTiming();
            SAMPLER3.stopTiming();
            SAMPLER4.startTiming();
            SAMPLER5.startTiming();
            SAMPLER6.startTiming();
            SAMPLER6.stopTiming();
            SAMPLER5.stopTiming();
            SAMPLER4.stopTiming();
            SAMPLER2.stopTiming();
            SAMPLER1.stopTiming();
        }
        long timingsCost = (System.nanoTime() - start) / (long)passes / 6L;
        SAMPLER1.reset(true);
        SAMPLER2.reset(true);
        SAMPLER3.reset(true);
        SAMPLER4.reset(true);
        SAMPLER5.reset(true);
        SAMPLER6.reset(true);
        return timingsCost;
    }

    private static JsonElement serializeConfigNode(ConfigurationNode node) {
        if (node.hasMapChildren()) {
            JsonObject object = new JsonObject();
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : node.getChildrenMap().entrySet()) {
                String fullPath = CONFIG_PATH_JOINER.join(entry.getValue().getPath());
                if (fullPath.equals("sponge.sql") || TimingsManager.hiddenConfigs.contains(fullPath)) continue;
                object.add(entry.getKey().toString(), TimingsExport.serializeConfigNode(entry.getValue()));
            }
            return object;
        }
        if (node.hasListChildren()) {
            JsonArray array = new JsonArray();
            for (ConfigurationNode configurationNode : node.getChildrenList()) {
                array.add(TimingsExport.serializeConfigNode(configurationNode));
            }
            return array;
        }
        return JSONUtil.toJsonElement(node.getValue());
    }

    @Override
    public synchronized void start() {
        boolean containsRconSource = false;
        for (MessageReceiver receiver : this.listeners.getChannel().getMembers()) {
            if (!(receiver instanceof RconSource)) continue;
            containsRconSource = true;
            break;
        }
        if (containsRconSource) {
            this.listeners.send(Text.of(TextColors.RED, "Warning: Timings report done over RCON will cause lag spikes."));
            this.listeners.send(Text.of(TextColors.RED, "You should use ", TextColors.YELLOW, "/sponge timings report" + TextColors.RED, " in game or console."));
            this.run();
        } else {
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.out.add("data", (JsonElement)JSONUtil.mapArray(this.history, TimingHistory::export));
        String response = null;
        String timingsURL = null;
        try {
            String hostname = "localhost";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (IOException e) {
                SpongeImpl.getLogger().warn("Could not get own server hostname when uploading timings - falling back to 'localhost'", (Throwable)e);
            }
            HttpURLConnection con = (HttpURLConnection)new URL("http://timings.aikar.co/post").openConnection();
            con.setDoOutput(true);
            con.setRequestProperty("User-Agent", "Sponge/" + TimingsExport.getServerName() + "/" + hostname);
            con.setRequestMethod("POST");
            con.setInstanceFollowRedirects(false);
            GZIPOutputStream request = new GZIPOutputStream(con.getOutputStream()){
                {
                    this.def.setLevel(7);
                }
            };
            ((OutputStream)request).write(JSONUtil.toString((JsonElement)this.out).getBytes("UTF-8"));
            ((OutputStream)request).close();
            response = this.getResponse(con);
            if (con.getResponseCode() != 302) {
                this.listeners.send(Text.of(TextColors.RED, "Upload Error: " + con.getResponseCode() + ": " + con.getResponseMessage()));
                this.listeners.send(Text.of(TextColors.RED, "Check your logs for more information"));
                if (response != null) {
                    SpongeImpl.getLogger().fatal(response);
                }
                this.listeners.done(timingsURL);
                return;
            }
            timingsURL = con.getHeaderField("Location");
            this.listeners.send(Text.of(TextColors.GREEN, "View Timings Report: ", TextActions.openUrl(new URL(timingsURL)), timingsURL));
            if (response != null && !response.isEmpty()) {
                SpongeImpl.getLogger().info("Timing Response: " + response);
            }
            this.listeners.done(timingsURL);
        }
        catch (IOException ex) {
            this.listeners.send(Text.of(TextColors.RED, "Error uploading timings, check your logs for more information"));
            if (response != null) {
                SpongeImpl.getLogger().fatal(response);
            }
            SpongeImpl.getLogger().fatal("Could not paste timings", (Throwable)ex);
        }
        finally {
            this.listeners.done(timingsURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponse(HttpURLConnection con) throws IOException {
        try (InputStream is = null;){
            int bytesRead;
            is = con.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((bytesRead = is.read(b)) != -1) {
                bos.write(b, 0, bytesRead);
            }
            String string = bos.toString();
            return string;
        }
    }
}

