/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import org.spongepowered.api.Nameable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.InventoryTransformation;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.ResettableBuilder;

public interface Inventory
extends Iterable<Inventory>,
Nameable {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public Inventory parent();

    public Inventory root();

    public <T extends Inventory> Iterable<T> slots();

    public <T extends Inventory> T first();

    public <T extends Inventory> T next();

    public Optional<ItemStack> poll();

    public Optional<ItemStack> poll(int var1);

    public Optional<ItemStack> peek();

    public Optional<ItemStack> peek(int var1);

    public InventoryTransactionResult offer(ItemStack var1);

    public InventoryTransactionResult set(ItemStack var1);

    public void clear();

    public int size();

    public int totalItems();

    public int capacity();

    public boolean hasChildren();

    public boolean contains(ItemStack var1);

    public boolean contains(ItemType var1);

    public boolean containsAny(ItemStack var1);

    public int getMaxStackSize();

    public void setMaxStackSize(int var1);

    public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Inventory var1, Class<T> var2);

    public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Class<T> var1);

    public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Inventory var1, Class<T> var2, Object var3);

    public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Class<T> var1, Object var2);

    public <T extends InventoryProperty<?, ?>> Optional<T> getInventoryProperty(Inventory var1, Class<T> var2);

    public <T extends InventoryProperty<?, ?>> Optional<T> getInventoryProperty(Class<T> var1);

    @Deprecated
    default public <T extends Inventory> T query(Class<?> ... types) {
        QueryOperation[] operations = new QueryOperation[types.length];
        for (int i = 0; i < types.length; ++i) {
            operations[i] = Inventory.class.isAssignableFrom(types[i]) ? QueryOperationTypes.INVENTORY_TYPE.of(types[i].asSubclass(Inventory.class)) : QueryOperationTypes.TYPE.of(types[i]);
        }
        return this.query(operations);
    }

    @Deprecated
    default public <T extends Inventory> T query(ItemType ... types) {
        QueryOperation[] operations = new QueryOperation[types.length];
        for (int i = 0; i < types.length; ++i) {
            operations[i] = QueryOperationTypes.ITEM_TYPE.of(types[i]);
        }
        return this.query(operations);
    }

    @Deprecated
    default public <T extends Inventory> T query(ItemStack ... types) {
        QueryOperation[] operations = new QueryOperation[types.length];
        for (int i = 0; i < types.length; ++i) {
            operations[i] = QueryOperationTypes.ITEM_STACK_EXACT.of(types[i]);
        }
        return this.query(operations);
    }

    @Deprecated
    default public <T extends Inventory> T query(InventoryProperty<?, ?> ... props) {
        QueryOperation[] operations = new QueryOperation[props.length];
        for (int i = 0; i < props.length; ++i) {
            operations[i] = QueryOperationTypes.INVENTORY_PROPERTY.of(props[i]);
        }
        return this.query(operations);
    }

    @Deprecated
    default public <T extends Inventory> T query(Translation ... names) {
        QueryOperation[] operations = new QueryOperation[names.length];
        for (int i = 0; i < names.length; ++i) {
            operations[i] = QueryOperationTypes.INVENTORY_TRANSLATION.of(names[i]);
        }
        return this.query(operations);
    }

    @Deprecated
    default public <T extends Inventory> T query(Object ... args) {
        ArrayList<QueryOperation<Object>> operations = new ArrayList<QueryOperation<Object>>(args.length);
        for (Object arg : args) {
            if (arg instanceof InventoryProperty) {
                operations.add(QueryOperationTypes.INVENTORY_PROPERTY.of((InventoryProperty)arg));
                continue;
            }
            if (arg instanceof Translation) {
                operations.add(QueryOperationTypes.INVENTORY_TRANSLATION.of((Translation)arg));
                continue;
            }
            if (arg instanceof Class && Inventory.class.isAssignableFrom((Class)arg)) {
                operations.add(QueryOperationTypes.INVENTORY_TYPE.of(((Class)arg).asSubclass(Inventory.class)));
                continue;
            }
            if (arg instanceof ItemStack) {
                operations.add(QueryOperationTypes.ITEM_STACK_IGNORE_QUANTITY.of((ItemStack)arg));
                continue;
            }
            if (!(arg instanceof ItemType)) continue;
            operations.add(QueryOperationTypes.ITEM_TYPE.of((ItemType)arg));
        }
        return this.query(operations.toArray(new QueryOperation[operations.size()]));
    }

    @Deprecated
    default public <T extends Inventory> T queryAny(ItemStack ... types) {
        QueryOperation[] operations = new QueryOperation[types.length];
        for (int i = 0; i < types.length; ++i) {
            operations[i] = QueryOperationTypes.ITEM_STACK_IGNORE_QUANTITY.of(types[i]);
        }
        return this.query(operations);
    }

    public <T extends Inventory> T query(QueryOperation<?> ... var1);

    public PluginContainer getPlugin();

    public InventoryArchetype getArchetype();

    public Inventory intersect(Inventory var1);

    public Inventory union(Inventory var1);

    public boolean containsInventory(Inventory var1);

    default public Inventory transform(InventoryTransformation transformation) {
        return transformation.transform(this);
    }

    public static interface Builder
    extends ResettableBuilder<Inventory, Builder> {
        public Builder of(InventoryArchetype var1);

        public Builder property(String var1, InventoryProperty<?, ?> var2);

        public Builder property(InventoryProperty<?, ?> var1);

        public Builder withCarrier(Carrier var1);

        public <E extends InteractInventoryEvent> Builder listener(Class<E> var1, Consumer<E> var2);

        public Builder forCarrier(Carrier var1);

        public Builder forCarrier(Class<? extends Carrier> var1);

        public Inventory build(Object var1);
    }
}

