/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.advancement.SpongeCriterionHelper;
import org.spongepowered.common.interfaces.advancement.IMixinAdvancement;
import org.spongepowered.common.registry.type.advancement.AdvancementRegistryModule;

public class SpongeAdvancementBuilder
implements Advancement.Builder {
    @Nullable
    private Advancement parent;
    private AdvancementCriterion criterion;
    @Nullable
    private DisplayInfo displayInfo;
    private String id;
    @Nullable
    private String name;

    public SpongeAdvancementBuilder() {
        this.reset();
    }

    @Override
    public Advancement.Builder parent(@Nullable Advancement parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Advancement.Builder criterion(AdvancementCriterion criterion) {
        Preconditions.checkNotNull((Object)criterion, (Object)"criterion");
        this.criterion = criterion;
        return this;
    }

    @Override
    public Advancement.Builder displayInfo(@Nullable DisplayInfo displayInfo) {
        this.displayInfo = displayInfo;
        return this;
    }

    @Override
    public Advancement.Builder id(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.id = id;
        return this;
    }

    @Override
    public Advancement.Builder name(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.name = name;
        return this;
    }

    @Override
    public Advancement build() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"The id must be set");
        PluginContainer plugin = Sponge.getCauseStackManager().getCurrentCause().first(PluginContainer.class).get();
        Tuple<Map<String, Criterion>, String[][]> result = SpongeCriterionHelper.toVanillaCriteriaData(this.criterion);
        AdvancementRewards rewards = AdvancementRewards.field_192114_a;
        ResourceLocation resourceLocation = new ResourceLocation(plugin.getId(), this.id);
        net.minecraft.advancements.DisplayInfo displayInfo = this.displayInfo == null ? null : (net.minecraft.advancements.DisplayInfo)((DisplayInfo.Builder)DisplayInfo.builder().from(this.displayInfo)).build();
        net.minecraft.advancements.Advancement parent = (net.minecraft.advancements.Advancement)this.parent;
        if (parent == null) {
            parent = AdvancementRegistryModule.DUMMY_ROOT_ADVANCEMENT;
        }
        Advancement advancement = (Advancement)new net.minecraft.advancements.Advancement(resourceLocation, parent, displayInfo, rewards, result.getFirst(), result.getSecond());
        ((IMixinAdvancement)((Object)advancement)).setCriterion(this.criterion);
        if (StringUtils.isNotEmpty((CharSequence)this.name)) {
            ((IMixinAdvancement)((Object)advancement)).setName(this.name);
        }
        return advancement;
    }

    @Override
    public Advancement.Builder reset() {
        this.criterion = AdvancementCriterion.EMPTY;
        this.displayInfo = null;
        this.parent = null;
        this.id = null;
        this.name = null;
        return this;
    }
}

