/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlock;

public final class BlockUtil {
    public static final UUID INVALID_WORLD_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");

    public static boolean setBlockState(World world, BlockPos position, BlockState state, boolean notifyNeighbors) {
        return world.func_180501_a(position, BlockUtil.toNative(state), notifyNeighbors ? 3 : 2);
    }

    public static boolean setBlockState(Chunk chunk, int x, int y, int z, BlockState state, boolean notifyNeighbors) {
        return BlockUtil.setBlockState(chunk, new BlockPos(x, y, z), state, notifyNeighbors);
    }

    public static boolean setBlockState(Chunk chunk, BlockPos position, BlockState state, boolean notifyNeighbors) {
        if (notifyNeighbors) {
            return BlockUtil.setBlockState(chunk.func_177412_p(), position, state, true);
        }
        return ((IMixinChunk)chunk).setBlockState(position, BlockUtil.toNative(state), chunk.func_177435_g(position), null, BlockChangeFlags.ALL.withUpdateNeighbors(notifyNeighbors)) != null;
    }

    public static IBlockState toNative(BlockState state) {
        if (state instanceof IBlockState) {
            return (IBlockState)state;
        }
        throw new UnsupportedOperationException("Custom BlockState implementations are not supported");
    }

    public static BlockState fromNative(IBlockState blockState) {
        if (blockState instanceof BlockState) {
            return (BlockState)blockState;
        }
        throw new UnsupportedOperationException("Custom BlockState implementations are not supported");
    }

    public static BlockType toBlock(IBlockState state) {
        return BlockUtil.fromNative(state).getType();
    }

    public static Block toBlock(BlockState state) {
        return BlockUtil.toNative(state).func_177230_c();
    }

    public static IMixinBlock toMixin(BlockState blockState) {
        return (IMixinBlock)BlockUtil.toNative(blockState).func_177230_c();
    }

    public static IMixinBlock toMixin(IBlockState blockState) {
        return (IMixinBlock)blockState.func_177230_c();
    }

    private BlockUtil() {
    }
}

