/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.ValueType;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.commented.SimpleCommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import ninja.leaping.configurate.util.ConfigurationNodeWalker;
import org.spongepowered.api.util.Functional;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.type.ConfigBase;
import org.spongepowered.common.config.type.CustomDataConfig;
import org.spongepowered.common.config.type.DimensionConfig;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.TrackerConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.util.IpSet;

public class SpongeConfig<T extends ConfigBase> {
    private static final String HEADER = "1.0\n\n# If you need help with the configuration or have any questions related to Sponge,\n# join us at the IRC or drop by our forums and leave a post.\n\n# IRC: #sponge @ irc.esper.net ( https://webchat.esper.net/?channel=sponge )\n# Forums: https://forums.spongepowered.org/\n";
    private static final ConfigurationOptions LOADER_OPTIONS = ConfigurationOptions.defaults().setHeader("1.0\n\n# If you need help with the configuration or have any questions related to Sponge,\n# join us at the IRC or drop by our forums and leave a post.\n\n# IRC: #sponge @ irc.esper.net ( https://webchat.esper.net/?channel=sponge )\n# Forums: https://forums.spongepowered.org/\n").setSerializers(TypeSerializers.getDefaultSerializers().newChild().registerType(TypeToken.of(IpSet.class), new IpSet.IpSetSerializer()));
    private final Type type;
    @Nullable
    private final SpongeConfig<?> parent;
    private HoconConfigurationLoader loader;
    private CommentedConfigurationNode fileData = SimpleCommentedConfigurationNode.root(LOADER_OPTIONS);
    private CommentedConfigurationNode data = SimpleCommentedConfigurationNode.root(LOADER_OPTIONS);
    private ObjectMapper.BoundInstance configMapper;
    private final String modId;

    public SpongeConfig(Type type, Path path, String modId, SpongeConfig<?> parent) {
        this.type = type;
        this.parent = parent;
        this.modId = modId;
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
            this.configMapper = ObjectMapper.forClass(this.type.type).bindToNew();
            this.reload();
            this.saveNow();
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Failed to initialize configuration", (Throwable)e);
        }
    }

    public T getConfig() {
        return (T)((ConfigBase)this.configMapper.getInstance());
    }

    public void save() {
        SpongeImpl.getConfigSaveManager().save(this);
    }

    public boolean saveNow() {
        try {
            SimpleCommentedConfigurationNode saveNode = SimpleCommentedConfigurationNode.root(LOADER_OPTIONS);
            this.configMapper.serialize(saveNode.getNode(this.modId));
            if (this.parent != null) {
                this.removeDuplicates(saveNode);
            }
            saveNode.mergeValuesFrom(this.fileData);
            this.loader.save(saveNode);
            return true;
        }
        catch (IOException | ObjectMappingException e) {
            SpongeImpl.getLogger().error("Failed to save configuration", (Throwable)e);
            return false;
        }
    }

    public void reload() {
        if (!SpongeImpl.getConfigSaveManager().flush(this)) {
            SpongeImpl.getLogger().error("Failed to load configuration due to error in flushing config");
            return;
        }
        try {
            CommentedConfigurationNode loadedNode = (CommentedConfigurationNode)this.loader.load();
            if (this.cleanupConfig(loadedNode)) {
                this.loader.save(loadedNode);
            }
            this.fileData = loadedNode;
            this.data = this.fileData.copy();
            if (this.parent != null) {
                this.data.mergeValuesFrom(this.parent.data);
            }
            this.populateInstance();
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Failed to load configuration", (Throwable)e);
        }
    }

    private static Object[] path(Object ... path) {
        return path;
    }

    private void populateInstance() throws ObjectMappingException {
        this.configMapper.populate(this.data.getNode(this.modId));
    }

    private boolean cleanupConfig(CommentedConfigurationNode root) {
        if (this.parent == null) {
            return false;
        }
        CommentedConfigurationNode configEnabled = root.getNode(this.modId, "config-enabled");
        if (configEnabled.isVirtual()) {
            return false;
        }
        boolean enabled = configEnabled.getBoolean(true);
        configEnabled.setValue(null);
        if (!enabled) {
            root.getNode(this.modId).setValue(null);
        } else {
            this.removeDuplicates(root);
        }
        return true;
    }

    private void removeDuplicates(CommentedConfigurationNode root) {
        if (this.parent == null) {
            throw new IllegalStateException("parent is null");
        }
        Iterator<ConfigurationNodeWalker.VisitedNode<CommentedConfigurationNode>> it = ConfigurationNodeWalker.DEPTH_FIRST_POST_ORDER.walkWithPath(root);
        while (it.hasNext()) {
            ConfigurationNodeWalker.VisitedNode<CommentedConfigurationNode> next = it.next();
            CommentedConfigurationNode node = next.getNode();
            if (node.hasMapChildren()) {
                if (!node.getChildrenMap().isEmpty()) continue;
                node.setValue(null);
                continue;
            }
            if (node.getParent() != null && node.getParent().getValueType() == ValueType.LIST) continue;
            CommentedConfigurationNode parentValue = this.parent.data.getNode(next.getPath().getArray());
            if (!Objects.equals(node.getValue(), parentValue.getValue())) continue;
            node.setValue(null);
        }
    }

    public CompletableFuture<CommentedConfigurationNode> updateSetting(String key, Object value) {
        return Functional.asyncFailableFuture(() -> {
            CommentedConfigurationNode upd = this.getSetting(key);
            upd.setValue(value);
            this.populateInstance();
            this.saveNow();
            return upd;
        }, ForkJoinPool.commonPool());
    }

    public CommentedConfigurationNode getRootNode() {
        return this.data.getNode(this.modId);
    }

    @Nullable
    public CommentedConfigurationNode getSetting(String key) {
        if (key.equalsIgnoreCase("config-enabled")) {
            return this.getRootNode().getNode(key);
        }
        if (!key.contains(".") || key.indexOf(46) == key.length() - 1) {
            return null;
        }
        String category = key.substring(0, key.indexOf(46));
        String prop = key.substring(key.indexOf(46) + 1);
        return this.getRootNode().getNode(category, prop);
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        CUSTOM_DATA(CustomDataConfig.class),
        TRACKER(TrackerConfig.class),
        GLOBAL(GlobalConfig.class),
        DIMENSION(DimensionConfig.class),
        WORLD(WorldConfig.class);

        final Class<? extends ConfigBase> type;

        private Type(Class<? extends ConfigBase> type) {
            this.type = type;
        }
    }
}

