/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.type;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import ninja.leaping.configurate.objectmapping.Setting;
import org.spongepowered.common.config.category.BrokenModCategory;
import org.spongepowered.common.config.category.BungeeCordCategory;
import org.spongepowered.common.config.category.CommandsCategory;
import org.spongepowered.common.config.category.ExploitCategory;
import org.spongepowered.common.config.category.GlobalGeneralCategory;
import org.spongepowered.common.config.category.GlobalWorldCategory;
import org.spongepowered.common.config.category.ModuleCategory;
import org.spongepowered.common.config.category.MovementChecksCategory;
import org.spongepowered.common.config.category.OptimizationCategory;
import org.spongepowered.common.config.category.PhaseTrackerCategory;
import org.spongepowered.common.config.category.SqlCategory;
import org.spongepowered.common.config.category.TeleportHelperCategory;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.util.IpSet;

public class GlobalConfig
extends GeneralConfigBase {
    @Setting(comment="Configuration options related to the Sql service, including connection aliases etc")
    private SqlCategory sql = new SqlCategory();
    @Setting
    private CommandsCategory commands = new CommandsCategory();
    @Setting(value="modules")
    private ModuleCategory mixins = new ModuleCategory();
    @Setting(value="ip-sets")
    private Map<String, List<IpSet>> ipSets = new HashMap<String, List<IpSet>>();
    @Setting(value="bungeecord")
    private BungeeCordCategory bungeeCord = new BungeeCordCategory();
    @Setting
    private ExploitCategory exploits = new ExploitCategory();
    @Setting(value="optimizations")
    private OptimizationCategory optimizations = new OptimizationCategory();
    @Setting
    protected GlobalGeneralCategory general = new GlobalGeneralCategory();
    @Setting
    protected GlobalWorldCategory world = new GlobalWorldCategory();
    @Setting(value="cause-tracker")
    private PhaseTrackerCategory causeTracker = new PhaseTrackerCategory();
    @Setting(value="teleport-helper", comment="Blocks to blacklist for safe teleportation.")
    private TeleportHelperCategory teleportHelper = new TeleportHelperCategory();
    @Setting(value="movement-checks")
    private MovementChecksCategory movementChecks = new MovementChecksCategory();
    @Setting(value="broken-mods", comment="Stopgap measures for dealing with broken mods")
    private BrokenModCategory brokenMods = new BrokenModCategory();

    public BrokenModCategory getBrokenMods() {
        return this.brokenMods;
    }

    public BungeeCordCategory getBungeeCord() {
        return this.bungeeCord;
    }

    public SqlCategory getSql() {
        return this.sql;
    }

    public CommandsCategory getCommands() {
        return this.commands;
    }

    public ModuleCategory getModules() {
        return this.mixins;
    }

    public Map<String, Predicate<InetAddress>> getIpSets() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.ipSets, (Function)new Function<List<IpSet>, Predicate<InetAddress>>(){

            @Nullable
            public Predicate<InetAddress> apply(List<IpSet> input) {
                return Predicates.and(input);
            }
        }));
    }

    public ExploitCategory getExploits() {
        return this.exploits;
    }

    public OptimizationCategory getOptimizations() {
        return this.optimizations;
    }

    public Predicate<InetAddress> getIpSet(String name) {
        return this.ipSets.containsKey(name) ? Predicates.and((Iterable)this.ipSets.get(name)) : null;
    }

    @Override
    public GlobalGeneralCategory getGeneral() {
        return this.general;
    }

    @Override
    public GlobalWorldCategory getWorld() {
        return this.world;
    }

    public PhaseTrackerCategory getPhaseTracker() {
        return this.causeTracker;
    }

    public TeleportHelperCategory getTeleportHelper() {
        return this.teleportHelper;
    }

    public MovementChecksCategory getMovementChecks() {
        return this.movementChecks;
    }
}

