/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.MoreObjects;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.KeyBasedDataListener;
import org.spongepowered.common.data.SpongeKeyBuilder;

public final class SpongeKey<V extends BaseValue<?>>
implements Key<V> {
    private static final Set<String> loggedPlugins = new HashSet<String>();
    private final TypeToken<V> valueToken;
    private final String id;
    private final String name;
    private final DataQuery query;
    private final TypeToken<?> elementToken;
    private final PluginContainer parent;
    @Nullable
    private List<KeyBasedDataListener<?>> listeners;

    SpongeKey(SpongeKeyBuilder<?, V> builder) {
        this.valueToken = builder.valueToken;
        this.name = builder.name;
        this.query = builder.query;
        this.elementToken = this.valueToken.resolveType(BaseValue.class.getTypeParameters()[0]);
        this.parent = SpongeKey.getCurrentContainer();
        String id = builder.id;
        if (id.indexOf(58) == -1) {
            this.id = this.parent.getId() + ':' + id;
        } else {
            this.id = id;
            if (loggedPlugins.add(this.parent.getId())) {
                SpongeImpl.getLogger().warn(this.parent.getId() + ": It is no longer required to include the plugin id when specifying a Key id through Key.Builder#id. This is deprecated and may be removed later. The plugin id will be retrieved from the current PluginContainer in the cause stack. Key: " + this);
            }
        }
    }

    private static PluginContainer getCurrentContainer() {
        return Sponge.getCauseStackManager().getCurrentCause().first(PluginContainer.class).orElse(SpongeImpl.getMinecraftPlugin());
    }

    @Override
    public TypeToken<V> getValueToken() {
        return this.valueToken;
    }

    @Override
    public TypeToken<?> getElementToken() {
        return this.elementToken;
    }

    @Override
    public DataQuery getQuery() {
        return this.query;
    }

    @Override
    public <E extends DataHolder> void registerEvent(Class<E> holderFilter, EventListener<ChangeDataHolderEvent.ValueChange> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(new KeyBasedDataListener<E>(holderFilter, this, listener, SpongeKey.getCurrentContainer()));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void registerListeners() {
        if (this.listeners != null) {
            for (KeyBasedDataListener<?> listener : this.listeners) {
                Sponge.getEventManager().registerListener((Object)listener.getOwner(), ChangeDataHolderEvent.ValueChange.class, listener);
            }
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeKey spongeKey = (SpongeKey)o;
        return Objects.equals(this.valueToken, spongeKey.valueToken) && Objects.equals(this.id, spongeKey.id) && Objects.equals(this.name, spongeKey.name) && Objects.equals(this.query, spongeKey.query) && Objects.equals(this.elementToken, spongeKey.elementToken);
    }

    public int hashCode() {
        return Objects.hash(this.valueToken, this.id, this.name, this.query, this.elementToken);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("id", (Object)this.id).add("valueToken", this.valueToken).add("elementToken", this.elementToken).add("query", (Object)this.query).toString();
    }

    public PluginContainer getParent() {
        return this.parent;
    }
}

