/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Locale;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.common.data.SpongeKey;

public final class SpongeKeyBuilder<E, V extends BaseValue<E>>
implements Key.Builder<E, V> {
    @Nullable
    TypeToken<V> valueToken;
    @Nullable
    String id;
    @Nullable
    String name;
    @Nullable
    DataQuery query;

    @Override
    public <T, B extends BaseValue<T>> Key.Builder<T, B> type(TypeToken<B> token) {
        this.valueToken = (TypeToken)Preconditions.checkNotNull(token, (Object)"Value Token cannot be null!");
        return this;
    }

    @Override
    public Key.Builder<E, V> id(String id) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)id, (Object)"ID cannot be null!")).contains(" ") ? 1 : 0) != 0, (Object)"Id cannot contain spaces!");
        this.id = id.toLowerCase(Locale.ENGLISH);
        return this;
    }

    @Override
    public Key.Builder<E, V> name(String name) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)name)).isEmpty() ? 1 : 0) != 0, (Object)"Name cannot be empty!");
        this.name = name;
        return this;
    }

    @Override
    public Key.Builder<E, V> query(DataQuery query) {
        Preconditions.checkArgument((!query.getParts().isEmpty() ? 1 : 0) != 0, (Object)"DataQuery cannot be null!");
        this.query = query;
        return this;
    }

    @Override
    public Key<V> build() {
        Preconditions.checkState((this.valueToken != null ? 1 : 0) != 0, (Object)"Value Token must be set!");
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"Key id must be set!");
        Preconditions.checkState((this.query != null ? 1 : 0) != 0, (Object)"DataQuery not set!");
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"Name must be set");
        return new SpongeKey(this);
    }

    @Override
    public Key.Builder<E, V> reset() {
        this.valueToken = null;
        this.id = null;
        this.name = null;
        this.query = null;
        return this;
    }
}

