/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.authlib;

import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.data.manipulator.mutable.SpongeRepresentedPlayerData;
import org.spongepowered.common.data.util.DataQueries;

public class SpongeGameProfileBuilder
extends AbstractDataBuilder<GameProfile> {
    public SpongeGameProfileBuilder() {
        super(GameProfile.class, 0);
    }

    @Override
    protected Optional<GameProfile> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(DataQueries.USER_UUID)) {
            return Optional.of(SpongeRepresentedPlayerData.NULL_PROFILE);
        }
        UUID uuid = this.getUUIDByString(container.getString(DataQueries.USER_UUID).get());
        if (!container.contains(DataQueries.USER_NAME)) {
            return Optional.of(GameProfile.of(uuid));
        }
        return Optional.of(GameProfile.of(uuid, container.getString(DataQueries.USER_NAME).get()));
    }

    private UUID getUUIDByString(String uuidString) throws InvalidDataException {
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataException("Invalid UUID string: " + uuidString);
        }
    }
}

