/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.block;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableConnectedDirectionData;
import org.spongepowered.api.data.manipulator.mutable.block.ConnectedDirectionData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableSetValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.block.SpongeConnectedDirectionData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeSetValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeConnectedDirectionData
extends AbstractImmutableData<ImmutableConnectedDirectionData, ConnectedDirectionData>
implements ImmutableConnectedDirectionData {
    private final ImmutableSet<Direction> directions;
    private final ImmutableSetValue<Direction> directionsValue;
    private final ImmutableValue<Boolean> northValue;
    private final ImmutableValue<Boolean> southValue;
    private final ImmutableValue<Boolean> eastValue;
    private final ImmutableValue<Boolean> westValue;

    public ImmutableSpongeConnectedDirectionData(Set<Direction> directions) {
        super(ImmutableConnectedDirectionData.class);
        this.directions = ImmutableSet.copyOf(directions);
        this.directionsValue = new ImmutableSpongeSetValue<Direction>((Key<BaseValue<Set<Direction>>>)Keys.CONNECTED_DIRECTIONS, (Set<Direction>)this.directions);
        this.northValue = ImmutableSpongeValue.cachedOf(Keys.CONNECTED_NORTH, false, this.directions.contains((Object)Direction.NORTH));
        this.southValue = ImmutableSpongeValue.cachedOf(Keys.CONNECTED_SOUTH, false, this.directions.contains((Object)Direction.SOUTH));
        this.eastValue = ImmutableSpongeValue.cachedOf(Keys.CONNECTED_EAST, false, this.directions.contains((Object)Direction.EAST));
        this.westValue = ImmutableSpongeValue.cachedOf(Keys.CONNECTED_WEST, false, this.directions.contains((Object)Direction.WEST));
        this.registerGetters();
    }

    @Override
    public ImmutableSetValue<Direction> connectedDirections() {
        return this.directionsValue;
    }

    @Override
    public ImmutableValue<Boolean> connectedNorth() {
        return this.northValue;
    }

    @Override
    public ImmutableValue<Boolean> connectedSouth() {
        return this.southValue;
    }

    @Override
    public ImmutableValue<Boolean> connectedEast() {
        return this.eastValue;
    }

    @Override
    public ImmutableValue<Boolean> connectedWest() {
        return this.westValue;
    }

    @Override
    public ConnectedDirectionData asMutable() {
        return new SpongeConnectedDirectionData((Set<Direction>)this.directions);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.CONNECTED_DIRECTIONS.getQuery(), this.directions).set(Keys.CONNECTED_NORTH.getQuery(), (Object)this.directions.contains((Object)Direction.NORTH)).set(Keys.CONNECTED_SOUTH.getQuery(), (Object)this.directions.contains((Object)Direction.SOUTH)).set(Keys.CONNECTED_EAST.getQuery(), (Object)this.directions.contains((Object)Direction.EAST)).set(Keys.CONNECTED_WEST.getQuery(), (Object)this.directions.contains((Object)Direction.WEST));
    }

    private Set<Direction> getDirections() {
        return this.directions;
    }

    private boolean isNorth() {
        return this.directions.contains((Object)Direction.NORTH);
    }

    private boolean isSouth() {
        return this.directions.contains((Object)Direction.SOUTH);
    }

    private boolean isEast() {
        return this.directions.contains((Object)Direction.EAST);
    }

    private boolean isWest() {
        return this.directions.contains((Object)Direction.WEST);
    }

    @Override
    protected void registerGetters() {
        this.registerKeyValue(Keys.CONNECTED_DIRECTIONS, this::connectedDirections);
        this.registerKeyValue(Keys.CONNECTED_NORTH, this::connectedNorth);
        this.registerKeyValue(Keys.CONNECTED_SOUTH, this::connectedSouth);
        this.registerKeyValue(Keys.CONNECTED_EAST, this::connectedEast);
        this.registerKeyValue(Keys.CONNECTED_WEST, this::connectedWest);
        this.registerFieldGetter(Keys.CONNECTED_DIRECTIONS, this::getDirections);
        this.registerFieldGetter(Keys.CONNECTED_NORTH, this::isNorth);
        this.registerFieldGetter(Keys.CONNECTED_SOUTH, this::isSouth);
        this.registerFieldGetter(Keys.CONNECTED_EAST, this::isEast);
        this.registerFieldGetter(Keys.CONNECTED_WEST, this::isWest);
    }
}

