/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAgeableData;
import org.spongepowered.api.data.manipulator.mutable.entity.AgeableData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeAgeableData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeAgeableData
extends AbstractData<AgeableData, ImmutableAgeableData>
implements AgeableData {
    private int age;
    private boolean adult;

    public SpongeAgeableData(int age, boolean adult) {
        super(AgeableData.class);
        this.age = age;
        this.adult = adult;
        this.registerGettersAndSetters();
    }

    public SpongeAgeableData() {
        this(1, true);
    }

    @Override
    public AgeableData copy() {
        return new SpongeAgeableData(this.age, this.adult);
    }

    @Override
    public ImmutableAgeableData asImmutable() {
        return new ImmutableSpongeAgeableData(this.age, this.adult);
    }

    @Override
    public MutableBoundedValue<Integer> age() {
        return SpongeValueFactory.boundedBuilder(Keys.AGE).minimum(Integer.MIN_VALUE).maximum(Integer.MAX_VALUE).defaultValue(0).actualValue(this.age).build();
    }

    @Override
    public Value<Boolean> adult() {
        return new SpongeValue<Boolean>(Keys.IS_ADULT, this.adult);
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.AGE, this::getAge);
        this.registerFieldSetter(Keys.AGE, this::setAge);
        this.registerKeyValue(Keys.AGE, this::age);
        this.registerFieldGetter(Keys.IS_ADULT, this::isAdult);
        this.registerFieldSetter(Keys.IS_ADULT, this::setAdult);
        this.registerKeyValue(Keys.IS_ADULT, this::adult);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.AGE, (Object)this.age).set(Keys.IS_ADULT, (Object)this.adult);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public boolean isAdult() {
        return this.adult;
    }

    public void setAdult(boolean adult) {
        this.adult = adult;
    }
}

