/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.monster.EntityVindicator;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableJohnnyData;
import org.spongepowered.api.data.manipulator.mutable.entity.JohnnyData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeJohnnyData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.interfaces.entity.monster.IMixinVindicator;

public class JohnnyDataProcessor
extends AbstractEntitySingleDataProcessor<EntityVindicator, Boolean, Value<Boolean>, JohnnyData, ImmutableJohnnyData> {
    public JohnnyDataProcessor() {
        super(EntityVindicator.class, Keys.IS_JOHNNY);
    }

    @Override
    protected boolean set(EntityVindicator dataHolder, Boolean value) {
        ((IMixinVindicator)dataHolder).setJohnny(value);
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(EntityVindicator dataHolder) {
        return Optional.of(((IMixinVindicator)dataHolder).isJohnny());
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(this.key, false, value);
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return new SpongeValue<Boolean>(this.key, false, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected JohnnyData createManipulator() {
        return new SpongeJohnnyData();
    }
}

