/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.world.LockCode;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableLockableData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.LockableData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeLockableData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public final class ItemLockableDataProcessor
extends AbstractItemSingleDataProcessor<String, Value<String>, LockableData, ImmutableLockableData> {
    public ItemLockableDataProcessor() {
        super((ItemStack stack) -> {
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemBlock)) {
                return false;
            }
            Block block = ((ItemBlock)item).func_179223_d();
            if (!(block instanceof ITileEntityProvider)) {
                return false;
            }
            TileEntity tile = ((ITileEntityProvider)block).func_149915_a(null, item.func_77647_b(stack.func_77952_i()));
            return tile instanceof TileEntityLockable;
        }, Keys.LOCK_TOKEN);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (this.supports(container)) {
            this.set((ItemStack)container, "");
            return DataTransactionResult.successNoData();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean set(ItemStack stack, String value) {
        NBTTagCompound mainCompound = NbtDataUtil.getOrCreateCompound(stack);
        NBTTagCompound tileCompound = NbtDataUtil.getOrCreateSubCompound(mainCompound, "BlockEntityTag");
        LockCode code = new LockCode(value);
        if (code.func_180160_a()) {
            tileCompound.func_82580_o("Lock");
        } else {
            code.func_180157_a(tileCompound);
        }
        return true;
    }

    @Override
    protected Optional<String> getVal(ItemStack container) {
        if (container.func_77978_p() == null) {
            return Optional.of("");
        }
        NBTTagCompound tileCompound = container.func_77978_p().func_74775_l("BlockEntityTag");
        LockCode code = LockCode.func_180158_b((NBTTagCompound)tileCompound);
        if (code.func_180160_a()) {
            return Optional.empty();
        }
        return Optional.of(code.func_180159_b());
    }

    @Override
    protected Value<String> constructValue(String actualValue) {
        return new SpongeValue<String>(Keys.LOCK_TOKEN, "", actualValue);
    }

    @Override
    protected ImmutableValue<String> constructImmutableValue(String value) {
        return new ImmutableSpongeValue<String>(Keys.LOCK_TOKEN, "", value);
    }

    @Override
    protected LockableData createManipulator() {
        return new SpongeLockableData();
    }
}

