/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.tileentity;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tileentity.TileEntityEndGateway;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableEndGatewayData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.EndGatewayData;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeEndGatewayData;
import org.spongepowered.common.data.processor.common.AbstractTileEntityDataProcessor;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntityEndGateway;

public final class EndGatewayDataProcessor
extends AbstractTileEntityDataProcessor<TileEntityEndGateway, EndGatewayData, ImmutableEndGatewayData> {
    public EndGatewayDataProcessor() {
        super(TileEntityEndGateway.class);
    }

    @Override
    protected boolean doesDataExist(TileEntityEndGateway container) {
        return true;
    }

    @Override
    protected boolean set(TileEntityEndGateway container, Map<Key<?>, Object> map) {
        Integer teleportCooldown;
        Vector3i exitPortal = (Vector3i)map.get(Keys.EXIT_POSITION);
        if (exitPortal != null) {
            ((IMixinTileEntityEndGateway)container).setExitPortal(exitPortal);
        }
        ((IMixinTileEntityEndGateway)container).setExactTeleport((Boolean)map.get(Keys.EXACT_TELEPORT));
        Long age = (Long)map.get(Keys.END_GATEWAY_AGE);
        if (age != null) {
            ((IMixinTileEntityEndGateway)container).setAge(age);
        }
        if ((teleportCooldown = (Integer)map.get(Keys.END_GATEWAY_TELEPORT_COOLDOWN)) != null) {
            ((IMixinTileEntityEndGateway)container).setTeleportCooldown(teleportCooldown);
        }
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(TileEntityEndGateway container) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Keys.EXIT_POSITION, (Object)((IMixinTileEntityEndGateway)container).getExitPortal());
        builder.put(Keys.EXACT_TELEPORT, (Object)((IMixinTileEntityEndGateway)container).isExactTeleport());
        builder.put(Keys.END_GATEWAY_AGE, (Object)((IMixinTileEntityEndGateway)container).getAge());
        builder.put(Keys.END_GATEWAY_TELEPORT_COOLDOWN, (Object)((IMixinTileEntityEndGateway)container).getTeleportCooldown());
        return builder.build();
    }

    @Override
    protected EndGatewayData createManipulator() {
        return new SpongeEndGatewayData();
    }

    @Override
    public Optional<EndGatewayData> fill(DataContainer container, EndGatewayData data) {
        Optional<Integer> teleportCooldown;
        Optional<Long> age;
        Optional<Boolean> exactTeleport;
        Preconditions.checkNotNull((Object)data, (Object)"data");
        Optional<Vector3i> exitPosition = container.getObject(Keys.EXIT_POSITION.getQuery(), Vector3i.class);
        if (exitPosition.isPresent()) {
            data = (EndGatewayData)data.set(Keys.EXIT_POSITION, exitPosition.get());
        }
        if ((exactTeleport = container.getBoolean(Keys.EXACT_TELEPORT.getQuery())).isPresent()) {
            data = (EndGatewayData)data.set(Keys.EXACT_TELEPORT, exactTeleport.get());
        }
        if ((age = container.getLong(Keys.END_GATEWAY_AGE.getQuery())).isPresent()) {
            data = (EndGatewayData)data.set(Keys.END_GATEWAY_AGE, age.get());
        }
        if ((teleportCooldown = container.getInt(Keys.END_GATEWAY_TELEPORT_COOLDOWN.getQuery())).isPresent()) {
            data = (EndGatewayData)data.set(Keys.END_GATEWAY_TELEPORT_COOLDOWN, teleportCooldown.get());
        }
        return Optional.of(data);
    }

    @Override
    public DataTransactionResult remove(DataHolder container) {
        return DataTransactionResult.failNoData();
    }
}

