/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.EntityAgeable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAgeableData;
import org.spongepowered.api.data.manipulator.mutable.entity.AgeableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeAgeableData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.util.DataUtil;

public class AgeableDataProcessor
extends AbstractEntityDataProcessor<EntityAgeable, AgeableData, ImmutableAgeableData> {
    public AgeableDataProcessor() {
        super(EntityAgeable.class);
    }

    @Override
    protected AgeableData createManipulator() {
        return new SpongeAgeableData(0, true);
    }

    @Override
    protected boolean doesDataExist(EntityAgeable entity) {
        return true;
    }

    @Override
    protected boolean set(EntityAgeable entity, Map<Key<?>, Object> keyValues) {
        Integer age = (Integer)keyValues.get(Keys.AGE);
        boolean adult = (Boolean)keyValues.get(Keys.IS_ADULT);
        if (age != null) {
            entity.func_70873_a(age.intValue());
            return true;
        }
        if (adult) {
            entity.func_70873_a(Integer.MAX_VALUE);
        } else {
            entity.func_70873_a(Integer.MIN_VALUE);
        }
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityAgeable entity) {
        return ImmutableMap.of(Keys.AGE, (Object)entity.func_70654_ax(), Keys.IS_ADULT, (Object)entity.func_70631_g_());
    }

    @Override
    public Optional<AgeableData> fill(DataContainer container, AgeableData ageableData) {
        if (!container.contains(Keys.AGE.getQuery()) || !container.contains(Keys.IS_ADULT.getQuery())) {
            return Optional.empty();
        }
        ageableData.set(Keys.AGE, DataUtil.getData(container, Keys.AGE));
        ageableData.set(Keys.IS_ADULT, DataUtil.getData(container, Keys.IS_ADULT));
        return Optional.of(ageableData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

