/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.item.EntityArmorStand;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableBodyPartRotationalData;
import org.spongepowered.api.data.manipulator.mutable.entity.BodyPartRotationalData;
import org.spongepowered.api.data.type.BodyPart;
import org.spongepowered.api.data.type.BodyParts;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeBodyPartRotationalData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.util.VecHelper;

public class ArmorStandBodyPartRotationalDataProcessor
extends AbstractEntityDataProcessor<EntityArmorStand, BodyPartRotationalData, ImmutableBodyPartRotationalData> {
    public ArmorStandBodyPartRotationalDataProcessor() {
        super(EntityArmorStand.class);
    }

    @Override
    protected BodyPartRotationalData createManipulator() {
        return new SpongeBodyPartRotationalData();
    }

    @Override
    public Optional<BodyPartRotationalData> fill(DataContainer container, BodyPartRotationalData data) {
        if (!container.contains(Keys.BODY_ROTATIONS.getQuery(), Keys.HEAD_ROTATION.getQuery(), Keys.CHEST_ROTATION.getQuery(), Keys.LEFT_ARM_ROTATION.getQuery(), Keys.RIGHT_ARM_ROTATION.getQuery(), Keys.LEFT_LEG_ROTATION.getQuery(), Keys.RIGHT_LEG_ROTATION.getQuery())) {
            return Optional.empty();
        }
        Map<?, ?> bodyRotations = container.getMap(Keys.BODY_ROTATIONS.getQuery()).get();
        Vector3d headRotation = DataUtil.getPosition3d(container, Keys.HEAD_ROTATION.getQuery());
        Vector3d chestRotation = DataUtil.getPosition3d(container, Keys.CHEST_ROTATION.getQuery());
        Vector3d leftArmRotation = DataUtil.getPosition3d(container, Keys.LEFT_ARM_ROTATION.getQuery());
        Vector3d rightArmRotation = DataUtil.getPosition3d(container, Keys.RIGHT_ARM_ROTATION.getQuery());
        Vector3d leftLegRotation = DataUtil.getPosition3d(container, Keys.LEFT_LEG_ROTATION.getQuery());
        Vector3d rightLegRotation = DataUtil.getPosition3d(container, Keys.RIGHT_LEG_ROTATION.getQuery());
        data.set(Keys.BODY_ROTATIONS, bodyRotations);
        data.set(Keys.HEAD_ROTATION, headRotation);
        data.set(Keys.CHEST_ROTATION, chestRotation);
        data.set(Keys.LEFT_ARM_ROTATION, leftArmRotation);
        data.set(Keys.RIGHT_ARM_ROTATION, rightArmRotation);
        data.set(Keys.LEFT_LEG_ROTATION, leftLegRotation);
        data.set(Keys.RIGHT_LEG_ROTATION, rightLegRotation);
        return Optional.of(data);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean doesDataExist(EntityArmorStand dataHolder) {
        return true;
    }

    @Override
    protected boolean set(EntityArmorStand dataHolder, Map<Key<?>, Object> keyValues) {
        Map bodyRotations = (Map)keyValues.get(Keys.BODY_ROTATIONS);
        Vector3d headRotation = ArmorStandBodyPartRotationalDataProcessor.getValueFromTwoMapsOrUseFallback(keyValues, Keys.HEAD_ROTATION, bodyRotations, BodyParts.HEAD, DataConstants.DEFAULT_HEAD_ROTATION);
        Vector3d chestRotation = ArmorStandBodyPartRotationalDataProcessor.getValueFromTwoMapsOrUseFallback(keyValues, Keys.CHEST_ROTATION, bodyRotations, BodyParts.CHEST, DataConstants.DEFAULT_CHEST_ROTATION);
        Vector3d leftArmRotation = ArmorStandBodyPartRotationalDataProcessor.getValueFromTwoMapsOrUseFallback(keyValues, Keys.LEFT_ARM_ROTATION, bodyRotations, BodyParts.LEFT_ARM, DataConstants.DEFAULT_LEFT_ARM_ROTATION);
        Vector3d rightArmRotation = ArmorStandBodyPartRotationalDataProcessor.getValueFromTwoMapsOrUseFallback(keyValues, Keys.RIGHT_ARM_ROTATION, bodyRotations, BodyParts.RIGHT_ARM, DataConstants.DEFAULT_RIGHT_ARM_ROTATION);
        Vector3d leftLegRotation = ArmorStandBodyPartRotationalDataProcessor.getValueFromTwoMapsOrUseFallback(keyValues, Keys.LEFT_LEG_ROTATION, bodyRotations, BodyParts.LEFT_LEG, DataConstants.DEFAULT_LEFT_LEG_ROTATION);
        Vector3d rightLegRotation = ArmorStandBodyPartRotationalDataProcessor.getValueFromTwoMapsOrUseFallback(keyValues, Keys.RIGHT_LEG_ROTATION, bodyRotations, BodyParts.RIGHT_LEG, DataConstants.DEFAULT_RIGHT_LEG_ROTATION);
        dataHolder.func_175415_a(VecHelper.toRotation(headRotation));
        dataHolder.func_175424_b(VecHelper.toRotation(chestRotation));
        dataHolder.func_175405_c(VecHelper.toRotation(leftArmRotation));
        dataHolder.func_175428_d(VecHelper.toRotation(rightArmRotation));
        dataHolder.func_175417_e(VecHelper.toRotation(leftLegRotation));
        dataHolder.func_175427_f(VecHelper.toRotation(rightLegRotation));
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityArmorStand dataHolder) {
        HashMap values = Maps.newHashMapWithExpectedSize((int)6);
        values.put(Keys.HEAD_ROTATION, VecHelper.toVector3d(dataHolder.func_175418_s()));
        values.put(Keys.CHEST_ROTATION, VecHelper.toVector3d(dataHolder.func_175408_t()));
        values.put(Keys.LEFT_ARM_ROTATION, VecHelper.toVector3d(dataHolder.field_175438_bj));
        values.put(Keys.RIGHT_ARM_ROTATION, VecHelper.toVector3d(dataHolder.field_175439_bk));
        values.put(Keys.LEFT_LEG_ROTATION, VecHelper.toVector3d(dataHolder.field_175440_bl));
        values.put(Keys.RIGHT_LEG_ROTATION, VecHelper.toVector3d(dataHolder.field_175441_bm));
        Collection<BodyPart> bodyParts = Sponge.getRegistry().getAllOf(BodyPart.class);
        List<Vector3d> rotations = Arrays.asList(values.values().toArray(new Vector3d[values.values().size()]));
        values.put(Keys.BODY_ROTATIONS, ArmorStandBodyPartRotationalDataProcessor.zipCollections(bodyParts, rotations));
        return values;
    }

    public static <K, V> Map<K, V> zipCollections(Collection<K> keys, Collection<V> values) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)Math.min(keys.size(), values.size()));
        Iterator<K> keyIter = keys.iterator();
        Iterator<V> valueIter = values.iterator();
        while (keyIter.hasNext() || valueIter.hasNext()) {
            map.put(keyIter.next(), valueIter.next());
        }
        return map;
    }

    private static <T> T getValueFromTwoMapsOrUseFallback(Map<?, ?> firstMap, Object keyForFirst, Map<?, ?> fallbackMap, Object keyForFallback, T fallbackValue) {
        return (T)Optional.ofNullable(firstMap.get(keyForFirst)).orElse(Optional.ofNullable(fallbackMap.get(keyForFallback)).orElse(fallbackValue));
    }
}

