/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableHealthData;
import org.spongepowered.api.data.manipulator.mutable.entity.HealthData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeHealthData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.registry.type.event.DamageSourceRegistryModule;

public class HealthDataProcessor
extends AbstractEntityDataProcessor<EntityLivingBase, HealthData, ImmutableHealthData> {
    public HealthDataProcessor() {
        super(EntityLivingBase.class);
    }

    @Override
    protected HealthData createManipulator() {
        return new SpongeHealthData(20.0, 20.0);
    }

    @Override
    protected boolean doesDataExist(EntityLivingBase entity) {
        return true;
    }

    @Override
    protected boolean set(EntityLivingBase entity, Map<Key<?>, Object> keyValues) {
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((Double)keyValues.get(Keys.MAX_HEALTH)).floatValue());
        float health = ((Double)keyValues.get(Keys.HEALTH)).floatValue();
        entity.func_70606_j(health);
        if (health == 0.0f) {
            entity.func_70097_a(DamageSourceRegistryModule.IGNORED_DAMAGE_SOURCE, 10000.0f);
        }
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityLivingBase entity) {
        double health = entity.func_110143_aJ();
        double maxHealth = entity.func_110138_aP();
        return ImmutableMap.of(Keys.HEALTH, (Object)health, Keys.MAX_HEALTH, (Object)maxHealth);
    }

    @Override
    public Optional<HealthData> fill(DataContainer container, HealthData healthData) {
        if (!container.contains(Keys.MAX_HEALTH.getQuery()) || !container.contains(Keys.HEALTH.getQuery())) {
            return Optional.empty();
        }
        healthData.set(Keys.MAX_HEALTH, DataUtil.getData(container, Keys.MAX_HEALTH));
        healthData.set(Keys.HEALTH, DataUtil.getData(container, Keys.HEALTH));
        return Optional.of(healthData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.builder().result(DataTransactionResult.Type.FAILURE).build();
    }
}

