/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.passive.EntityHorse;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HorseColor;
import org.spongepowered.api.data.type.HorseColors;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.SpongeHorseColor;
import org.spongepowered.common.entity.SpongeHorseStyle;
import org.spongepowered.common.registry.type.entity.HorseColorRegistryModule;
import org.spongepowered.common.registry.type.entity.HorseStyleRegistryModule;

public class HorseColorValueProcessor
extends AbstractSpongeValueProcessor<EntityHorse, HorseColor, Value<HorseColor>> {
    public HorseColorValueProcessor() {
        super(EntityHorse.class, Keys.HORSE_COLOR);
    }

    @Override
    protected Value<HorseColor> constructValue(HorseColor defaultValue) {
        return new SpongeValue<HorseColor>(Keys.HORSE_COLOR, defaultValue);
    }

    @Override
    protected boolean set(EntityHorse container, HorseColor value) {
        SpongeHorseStyle style = (SpongeHorseStyle)HorseStyleRegistryModule.getHorseStyle(container);
        container.func_110235_q(EntityUtil.getHorseInternalVariant((SpongeHorseColor)value, style));
        return true;
    }

    @Override
    protected Optional<HorseColor> getVal(EntityHorse container) {
        return Optional.of(HorseColorRegistryModule.getHorseColor(container));
    }

    @Override
    protected ImmutableValue<HorseColor> constructImmutableValue(HorseColor value) {
        return ImmutableSpongeValue.cachedOf(Keys.HORSE_COLOR, HorseColors.WHITE, value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

