/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.interfaces.entity.IMixinEntityLivingBase;

public class MaxAirValueProcessor
extends AbstractSpongeValueProcessor<IMixinEntityLivingBase, Integer, MutableBoundedValue<Integer>> {
    public MaxAirValueProcessor() {
        super(IMixinEntityLivingBase.class, Keys.MAX_AIR);
    }

    @Override
    public MutableBoundedValue<Integer> constructValue(Integer defaultValue) {
        return SpongeValueFactory.boundedBuilder(Keys.MAX_AIR).defaultValue(300).minimum(0).maximum(Integer.MAX_VALUE).actualValue(defaultValue).build();
    }

    @Override
    protected boolean set(IMixinEntityLivingBase container, Integer value) {
        container.setMaxAir(value);
        return true;
    }

    @Override
    protected Optional<Integer> getVal(IMixinEntityLivingBase container) {
        return Optional.of(container.getMaxAir());
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

