/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketDestroyEntities;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketServerDifficulty;
import net.minecraft.network.play.server.SPacketSpawnPainting;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.world.Dimension;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeHorseColor;
import org.spongepowered.common.entity.SpongeHorseStyle;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.interfaces.IMixinPlayerList;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.entity.IMixinEntityLivingBase;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.interfaces.item.IMixinItem;
import org.spongepowered.common.interfaces.network.IMixinNetHandlerPlayServer;
import org.spongepowered.common.interfaces.world.IMixinITeleporter;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.registry.type.entity.ProfessionRegistryModule;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.WorldManager;

public final class EntityUtil {
    private static final BlockPos HANGING_OFFSET_EAST = new BlockPos(1, 1, 0);
    private static final BlockPos HANGING_OFFSET_WEST = new BlockPos(-1, 1, 0);
    private static final BlockPos HANGING_OFFSET_NORTH = new BlockPos(0, 1, -1);
    private static final BlockPos HANGING_OFFSET_SOUTH = new BlockPos(0, 1, 1);
    public static final Function<PhaseContext<?>, Supplier<Optional<UUID>>> ENTITY_CREATOR_FUNCTION = context -> () -> Stream.builder().add(() -> context.getSource(User.class)).add(context::getNotifier).add(context::getOwner).build().map(Supplier::get).filter(Optional::isPresent).map(Optional::get).map(Identifiable::getUniqueId).findFirst();
    private static final Predicate<net.minecraft.entity.Entity> TRACEABLE = Predicates.and((Predicate)EntitySelectors.field_180132_d, entity -> entity != null && entity.func_70067_L());
    public static final Function<Humanoid, EntityPlayer> HUMANOID_TO_PLAYER = humanoid -> humanoid instanceof EntityPlayer ? (EntityPlayer)humanoid : null;
    public static boolean tempIsBedSpawn = false;

    private EntityUtil() {
    }

    @Nullable
    public static net.minecraft.entity.Entity transferEntityToDimension(IMixinEntity mixinEntity, int toSuggestedDimension, IMixinITeleporter teleporter) {
        net.minecraft.entity.Entity entity = EntityUtil.toNative(mixinEntity);
        MoveEntityEvent.Teleport.Portal event = EntityUtil.handleDisplaceEntityPortalEvent(entity, toSuggestedDimension, teleporter);
        if (event == null || event.isCancelled()) {
            return null;
        }
        entity.field_70170_p.field_72984_F.func_76320_a("changeDimension");
        Transform<World> toTransform = event.getToTransform();
        WorldServer toWorld = (WorldServer)toTransform.getExtent();
        entity.field_70170_p.func_72900_e(entity);
        entity.field_70128_L = false;
        entity.field_70170_p.field_72984_F.func_76320_a("reposition");
        Vector3i toChunkPosition = toTransform.getLocation().getChunkPosition();
        toWorld.func_72863_F().func_186028_c(toChunkPosition.getX(), toChunkPosition.getZ());
        Vector3d toPosition = toTransform.getPosition();
        entity.func_70012_b(toPosition.getX(), toPosition.getY(), toPosition.getZ(), (float)toTransform.getYaw(), (float)toTransform.getPitch());
        entity.field_70170_p = toWorld;
        toWorld.func_72838_d(entity);
        toWorld.func_72866_a(entity, false);
        entity.field_70170_p.field_72984_F.func_76319_b();
        entity.field_70170_p.field_72984_F.func_76319_b();
        entity.field_70170_p.field_72984_F.func_76319_b();
        return entity;
    }

    @Nullable
    public static net.minecraft.entity.Entity teleportPlayerToDimension(EntityPlayerMP entityPlayerMP, int suggestedDimensionId, IMixinITeleporter teleporter) {
        MoveEntityEvent.Teleport.Portal event = EntityUtil.handleDisplaceEntityPortalEvent((net.minecraft.entity.Entity)entityPlayerMP, suggestedDimensionId, teleporter);
        if (event == null || event.isCancelled()) {
            return entityPlayerMP;
        }
        entityPlayerMP.field_184851_cj = true;
        boolean sameDimension = entityPlayerMP.field_71093_bK == suggestedDimensionId;
        WorldServer fromWorldServer = (WorldServer)event.getFromTransform().getExtent();
        if (fromWorldServer.field_73011_w instanceof WorldProviderEnd && suggestedDimensionId == 1) {
            fromWorldServer.func_72900_e((net.minecraft.entity.Entity)entityPlayerMP);
            if (!entityPlayerMP.field_71136_j) {
                entityPlayerMP.field_71136_j = true;
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(4, entityPlayerMP.field_192040_cp ? 0.0f : 1.0f));
                entityPlayerMP.field_192040_cp = true;
            }
            return entityPlayerMP;
        }
        WorldServer toWorldServer = (WorldServer)event.getToTransform().getExtent();
        if (!sameDimension && fromWorldServer == toWorldServer) {
            return entityPlayerMP;
        }
        EntityUtil.transferPlayerToDimension(event, entityPlayerMP);
        entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketEffect(1032, BlockPos.field_177992_a, 0, false));
        return entityPlayerMP;
    }

    public static void transferPlayerToDimension(MoveEntityEvent.Teleport.Portal event, EntityPlayerMP playerIn) {
        WorldServer fromWorld = (WorldServer)event.getFromTransform().getExtent();
        WorldServer toWorld = (WorldServer)event.getToTransform().getExtent();
        playerIn.field_71093_bK = WorldManager.getClientDimensionId(playerIn, (net.minecraft.world.World)toWorld);
        toWorld.func_72863_F().func_186028_c(event.getToTransform().getLocation().getChunkPosition().getX(), event.getToTransform().getLocation().getChunkPosition().getZ());
        int dimensionId = playerIn.field_71093_bK;
        if (((IMixinEntityPlayerMP)playerIn).usesCustomClient()) {
            WorldManager.sendDimensionRegistration(playerIn, toWorld.field_73011_w);
        } else if (fromWorld != toWorld && fromWorld.field_73011_w.func_186058_p() == toWorld.field_73011_w.func_186058_p()) {
            playerIn.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimensionId >= 0 ? -1 : 0, toWorld.func_175659_aa(), toWorld.func_72912_H().func_76067_t(), playerIn.field_71134_c.func_73081_b()));
        }
        playerIn.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimensionId, toWorld.func_175659_aa(), toWorld.func_72912_H().func_76067_t(), playerIn.field_71134_c.func_73081_b()));
        playerIn.field_71135_a.func_147359_a((Packet)new SPacketServerDifficulty(toWorld.func_175659_aa(), toWorld.func_72912_H().func_176123_z()));
        SpongeImpl.getServer().func_184103_al().func_187243_f(playerIn);
        fromWorld.func_72973_f((net.minecraft.entity.Entity)playerIn);
        playerIn.field_70128_L = false;
        ((IMixinEntity)playerIn).setLocationAndAngles(event.getToTransform());
        playerIn.func_70029_a((net.minecraft.world.World)toWorld);
        toWorld.func_72838_d((net.minecraft.entity.Entity)playerIn);
        toWorld.func_72866_a((net.minecraft.entity.Entity)playerIn, false);
        SpongeImpl.getServer().func_184103_al().func_72375_a(playerIn, fromWorld);
        playerIn.field_71135_a.func_147364_a(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, playerIn.field_70177_z, playerIn.field_70125_A);
        playerIn.field_71134_c.func_73080_a(toWorld);
        SpongeImpl.getServer().func_184103_al().func_72354_b(playerIn, toWorld);
        SpongeImpl.getServer().func_184103_al().func_72385_f(playerIn);
        playerIn.field_71135_a.func_147359_a((Packet)new SPacketEntityStatus((net.minecraft.entity.Entity)playerIn, toWorld.func_82736_K().func_82766_b("reducedDebugInfo") ? (byte)22 : 23));
        for (PotionEffect potioneffect : playerIn.func_70651_bq()) {
            playerIn.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(playerIn.func_145782_y(), potioneffect));
        }
        ((IMixinEntityPlayerMP)playerIn).refreshXpHealthAndFood();
        SpongeImplHooks.handlePostChangeDimensionEvent(playerIn, fromWorld, toWorld);
    }

    public static boolean isEntityDead(Entity entity) {
        return EntityUtil.isEntityDead((net.minecraft.entity.Entity)entity);
    }

    private static boolean isEntityDead(net.minecraft.entity.Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase base = (EntityLivingBase)entity;
            return base.func_110143_aJ() <= 0.0f || base.field_70725_aQ > 0 || base.field_70729_aU;
        }
        return entity.field_70128_L;
    }

    public static MoveEntityEvent.Teleport handleDisplaceEntityTeleportEvent(net.minecraft.entity.Entity entityIn, Location<World> location) {
        Transform<World> fromTransform = ((IMixinEntity)entityIn).getTransform();
        Transform<World> toTransform = fromTransform.setLocation(location).setRotation(new Vector3d(entityIn.field_70125_A, entityIn.field_70177_z, 0.0f));
        return EntityUtil.handleDisplaceEntityTeleportEvent(entityIn, fromTransform, toTransform);
    }

    public static MoveEntityEvent.Teleport handleDisplaceEntityTeleportEvent(net.minecraft.entity.Entity entityIn, double posX, double posY, double posZ, float yaw, float pitch) {
        Transform<World> fromTransform = ((IMixinEntity)entityIn).getTransform();
        Transform<World> toTransform = fromTransform.setPosition(new Vector3d(posX, posY, posZ)).setRotation(new Vector3d(pitch, yaw, 0.0f));
        return EntityUtil.handleDisplaceEntityTeleportEvent(entityIn, fromTransform, toTransform);
    }

    public static MoveEntityEvent.Teleport handleDisplaceEntityTeleportEvent(net.minecraft.entity.Entity entityIn, Transform<World> fromTransform, Transform<World> toTransform) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseData peek = phaseTracker.getCurrentPhaseData();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entityIn);
            MoveEntityEvent.Teleport event = SpongeEventFactory.createMoveEntityEventTeleport(Sponge.getCauseStackManager().getCurrentCause(), fromTransform, toTransform, (Entity)entityIn);
            SpongeImpl.postEvent(event);
            MoveEntityEvent.Teleport teleport = event;
            return teleport;
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static MoveEntityEvent.Teleport.Portal handleDisplaceEntityPortalEvent(net.minecraft.entity.Entity entityIn, int targetDimensionId, IMixinITeleporter teleporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IMixinWorldServer getMixinWorld(Entity entity) {
        return (IMixinWorldServer)((Object)entity.getWorld());
    }

    public static IMixinWorldServer getMixinWorld(net.minecraft.entity.Entity entity) {
        return (IMixinWorldServer)entity.field_70170_p;
    }

    public static WorldServer getMinecraftWorld(Entity entity) {
        return (WorldServer)entity.getWorld();
    }

    public static World getSpongeWorld(net.minecraft.entity.Entity player) {
        return (World)player.field_70170_p;
    }

    public static Player toPlayer(EntityPlayer player) {
        return (Player)player;
    }

    public static int getHorseInternalVariant(SpongeHorseColor color, SpongeHorseStyle style) {
        return color.getBitMask() | style.getBitMask();
    }

    public static boolean processEntitySpawnsFromEvent(SpawnEntityEvent event, Supplier<Optional<UUID>> entityCreatorSupplier) {
        boolean spawnedAny = false;
        for (Entity entity : event.getEntities()) {
            spawnedAny = EntityUtil.processEntitySpawn(entity, entityCreatorSupplier);
        }
        return spawnedAny;
    }

    public static boolean processEntitySpawnsFromEvent(PhaseContext<?> context, SpawnEntityEvent destruct) {
        User creator = context.getNotifier().orElse(context.getOwner().orElse(null));
        return EntityUtil.processEntitySpawnsFromEvent(destruct, ENTITY_CREATOR_FUNCTION.apply(context));
    }

    public static boolean processEntitySpawn(Entity entity, Supplier<Optional<UUID>> supplier) {
        Optional<net.minecraft.entity.Entity> customEntityItem;
        ItemStack item;
        net.minecraft.entity.Entity minecraftEntity = EntityUtil.toNative(entity);
        if (minecraftEntity instanceof EntityItem && !(item = ((EntityItem)minecraftEntity).func_92059_d()).func_190926_b() && (customEntityItem = ((IMixinItem)item.func_77973_b()).getCustomEntityItem(minecraftEntity.func_130014_f_(), minecraftEntity, item)).isPresent()) {
            net.minecraft.entity.Entity entityToSpawn = customEntityItem.get();
            supplier.get().ifPresent(creator -> EntityUtil.toMixin(entityToSpawn).setCreator((UUID)creator));
            EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
            return true;
        }
        supplier.get().ifPresent(creator -> EntityUtil.toMixin(entity).setCreator((UUID)creator));
        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
        return true;
    }

    public static ItemStack getItem(net.minecraft.entity.Entity entity) {
        return entity instanceof EntityItem ? ((EntityItem)entity).func_92059_d() : ItemStack.field_190927_a;
    }

    public static RayTraceResult rayTraceFromEntity(net.minecraft.entity.Entity source, double traceDistance, float partialTicks, boolean includeEntities) {
        RayTraceResult blockRay = EntityUtil.rayTraceFromEntity(source, traceDistance, partialTicks);
        if (!includeEntities) {
            return blockRay;
        }
        Vec3d traceStart = EntityUtil.getPositionEyes(source, partialTicks);
        double blockDistance = blockRay != null ? blockRay.field_72307_f.func_72438_d(traceStart) : traceDistance;
        EntityTrace entityRay = EntityUtil.rayTraceEntities(source, traceDistance, partialTicks, blockDistance, traceStart);
        if (entityRay.entity != null && (entityRay.distance < blockDistance || blockRay == null)) {
            return entityRay.asRayTraceResult();
        }
        return blockRay;
    }

    private static EntityTrace rayTraceEntities(net.minecraft.entity.Entity source, double traceDistance, float partialTicks, double blockDistance, Vec3d traceStart) {
        EntityTrace trace = new EntityTrace(blockDistance);
        Vec3d lookDir = source.func_70676_i(partialTicks).func_186678_a(traceDistance);
        Vec3d traceEnd = traceStart.func_178787_e(lookDir);
        for (net.minecraft.entity.Entity entity : EntityUtil.getTraceEntities(source, traceDistance, lookDir, TRACEABLE)) {
            double distanceToEntity;
            AxisAlignedBB entityBB = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult entityRay = entityBB.func_72327_a(traceStart, traceEnd);
            if (entityBB.func_72318_a(traceStart)) {
                if (!(trace.distance >= 0.0)) continue;
                trace.entity = entity;
                trace.location = entityRay == null ? traceStart : entityRay.field_72307_f;
                trace.distance = 0.0;
                continue;
            }
            if (entityRay == null || !((distanceToEntity = traceStart.func_72438_d(entityRay.field_72307_f)) < trace.distance) && trace.distance != 0.0) continue;
            if (entity.func_184208_bv() == source.func_184208_bv()) {
                if (trace.distance != 0.0) continue;
                trace.entity = entity;
                trace.location = entityRay.field_72307_f;
                continue;
            }
            trace.entity = entity;
            trace.location = entityRay.field_72307_f;
            trace.distance = distanceToEntity;
        }
        return trace;
    }

    private static List<net.minecraft.entity.Entity> getTraceEntities(net.minecraft.entity.Entity source, double traceDistance, Vec3d dir, Predicate<net.minecraft.entity.Entity> filter) {
        AxisAlignedBB boundingBox = source.func_174813_aQ();
        AxisAlignedBB traceBox = boundingBox.func_72321_a(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        List entities = source.field_70170_p.func_175674_a(source, traceBox.func_72314_b(1.0, 1.0, 1.0), filter);
        return entities;
    }

    @Nullable
    public static RayTraceResult rayTraceFromEntity(net.minecraft.entity.Entity source, double traceDistance, float partialTicks) {
        Vec3d traceStart = EntityUtil.getPositionEyes(source, partialTicks);
        Vec3d lookDir = source.func_70676_i(partialTicks).func_186678_a(traceDistance);
        Vec3d traceEnd = traceStart.func_178787_e(lookDir);
        return source.field_70170_p.func_147447_a(traceStart, traceEnd, false, false, true);
    }

    private static Vec3d getPositionEyes(net.minecraft.entity.Entity entity, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        }
        double interpX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double interpY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + (double)entity.func_70047_e();
        double interpZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        return new Vec3d(interpX, interpY, interpZ);
    }

    public static boolean refreshPainting(EntityPainting painting, EntityPainting.EnumArt art) {
        EntityPainting.EnumArt oldArt = painting.field_70522_e;
        painting.field_70522_e = art;
        painting.func_174859_a(painting.field_174860_b);
        if (!painting.func_70518_d()) {
            painting.field_70522_e = oldArt;
            painting.func_174859_a(painting.field_174860_b);
            return false;
        }
        EntityTracker paintingTracker = ((WorldServer)painting.field_70170_p).func_73039_n();
        EntityTrackerEntry paintingEntry = (EntityTrackerEntry)paintingTracker.field_72794_c.func_76041_a(painting.func_145782_y());
        ArrayList<EntityPlayerMP> playerMPs = new ArrayList<EntityPlayerMP>();
        for (EntityPlayerMP player : paintingEntry.field_73134_o) {
            SPacketDestroyEntities packet = new SPacketDestroyEntities(new int[]{painting.func_145782_y()});
            player.field_71135_a.func_147359_a((Packet)packet);
            playerMPs.add(player);
        }
        for (EntityPlayerMP playerMP : playerMPs) {
            SpongeImpl.getGame().getScheduler().createTaskBuilder().delayTicks(SpongeImpl.getGlobalConfig().getConfig().getEntity().getPaintingRespawnDelaly()).execute(() -> {
                SPacketSpawnPainting packet = new SPacketSpawnPainting(painting);
                playerMP.field_71135_a.func_147359_a((Packet)packet);
            }).submit(SpongeImpl.getPlugin());
        }
        return true;
    }

    public static Profession validateProfession(int professionId) {
        List professions = (List)ProfessionRegistryModule.getInstance().getAll();
        for (Profession profession : professions) {
            if (!(profession instanceof SpongeProfession) || professionId != ((SpongeProfession)profession).type) continue;
            return profession;
        }
        throw new IllegalStateException("Invalid Villager profession id is present! Found: " + professionId + " when the expected contain: " + professions);
    }

    public static List<EntityHanging> findHangingEntities(WorldServer worldIn, BlockPos pos) {
        return worldIn.func_175647_a(EntityHanging.class, new AxisAlignedBB(pos, pos).func_72314_b(1.1, 1.1, 1.1), entityIn -> {
            if (entityIn == null) {
                return false;
            }
            BlockPos entityPos = entityIn.func_180425_c();
            if (entityPos.equals((Object)pos.func_177982_a(0, 1, 0))) {
                return true;
            }
            EnumFacing entityFacing = entityIn.func_174811_aO();
            if (entityFacing == EnumFacing.NORTH) {
                return entityPos.equals((Object)pos.func_177971_a((Vec3i)HANGING_OFFSET_NORTH));
            }
            if (entityFacing == EnumFacing.SOUTH) {
                return entityIn.func_180425_c().equals((Object)pos.func_177971_a((Vec3i)HANGING_OFFSET_SOUTH));
            }
            if (entityFacing == EnumFacing.WEST) {
                return entityIn.func_180425_c().equals((Object)pos.func_177971_a((Vec3i)HANGING_OFFSET_WEST));
            }
            if (entityFacing == EnumFacing.EAST) {
                return entityIn.func_180425_c().equals((Object)pos.func_177971_a((Vec3i)HANGING_OFFSET_EAST));
            }
            return false;
        });
    }

    public static Location<World> getPlayerRespawnLocation(EntityPlayerMP playerIn, @Nullable WorldServer targetWorld) {
        Location<World> location = ((World)playerIn.field_70170_p).getSpawnLocation();
        tempIsBedSpawn = false;
        if (targetWorld == null) {
            return location;
        }
        Dimension targetDimension = (Dimension)targetWorld.field_73011_w;
        int targetDimensionId = ((IMixinWorldServer)targetWorld).getDimensionId();
        if (!targetDimension.allowsPlayerRespawns()) {
            targetDimensionId = SpongeImplHooks.getRespawnDimension((WorldProvider)targetDimension, playerIn);
            targetWorld = targetWorld.func_73046_m().func_71218_a(targetDimensionId);
        }
        Vector3d targetSpawnVec = VecHelper.toVector3d(targetWorld.func_175694_M());
        BlockPos bedPos = SpongeImplHooks.getBedLocation((EntityPlayer)playerIn, targetDimensionId);
        if (bedPos != null) {
            boolean forceBedSpawn = SpongeImplHooks.isSpawnForced((EntityPlayer)playerIn, targetDimensionId);
            BlockPos bedSpawnLoc = EntityPlayer.func_180467_a((net.minecraft.world.World)targetWorld, (BlockPos)bedPos, (boolean)forceBedSpawn);
            if (bedSpawnLoc != null) {
                tempIsBedSpawn = true;
                targetSpawnVec = new Vector3d((double)bedSpawnLoc.func_177958_n() + 0.5, (double)bedSpawnLoc.func_177956_o() + 0.1, (double)bedSpawnLoc.func_177952_p() + 0.5);
            } else {
                playerIn.field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(0, 0.0f));
            }
        }
        return new Location<World>((World)targetWorld, targetSpawnVec);
    }

    public static net.minecraft.entity.Entity toNative(Entity tickingEntity) {
        if (!(tickingEntity instanceof net.minecraft.entity.Entity)) {
            throw new IllegalArgumentException("Not a native Entity for this implementation!");
        }
        return (net.minecraft.entity.Entity)tickingEntity;
    }

    public static EntityLivingBase toNative(IMixinEntityLivingBase entityLivingBase) {
        if (!(entityLivingBase instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("Not a native EntityLivingBase for this implementation!");
        }
        return (EntityLivingBase)entityLivingBase;
    }

    public static EntityPlayer toNative(IMixinEntityPlayer player) {
        if (!(player instanceof EntityPlayer)) {
            throw new IllegalArgumentException("Not a native EntityPlayer for this implementation!");
        }
        return (EntityPlayer)player;
    }

    @Nullable
    public static net.minecraft.entity.Entity toNullableNative(@Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        if (!(entity instanceof net.minecraft.entity.Entity)) {
            throw new IllegalArgumentException("Not a native Entity for this implementation!");
        }
        return (net.minecraft.entity.Entity)entity;
    }

    public static Entity fromNative(net.minecraft.entity.Entity entity) {
        return (Entity)entity;
    }

    public static Living fromNativeToLiving(net.minecraft.entity.Entity entity) {
        if (!(entity instanceof Living)) {
            throw new IllegalArgumentException("Entity is incompatible with SpongeAPI Living interface: " + entity);
        }
        return (Living)entity;
    }

    public static EntityLivingBase toNative(Living entity) {
        if (!(entity instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("Living entity is not compatible with this implementation: " + entity);
        }
        return (EntityLivingBase)entity;
    }

    public static EntityPlayerMP toNative(Player player) {
        if (!(player instanceof EntityPlayerMP)) {
            throw new IllegalArgumentException("Player entity is not compatible with this implementation: " + player);
        }
        return (EntityPlayerMP)player;
    }

    public static EntityPlayerMP toNative(IMixinEntityPlayerMP playerMP) {
        if (!(playerMP instanceof EntityPlayerMP)) {
            throw new IllegalArgumentException("Player entity is not compatible with this implementation: " + playerMP);
        }
        return (EntityPlayerMP)playerMP;
    }

    public static IMixinEntity toMixin(net.minecraft.entity.Entity entity) {
        if (!(entity instanceof IMixinEntity)) {
            throw new IllegalArgumentException("Not a mixin Entity for this implementation!");
        }
        return (IMixinEntity)entity;
    }

    public static IMixinEntity toMixin(Entity entity) {
        if (!(entity instanceof IMixinEntity)) {
            throw new IllegalArgumentException("Not a mixin Entity for this implementation!");
        }
        return (IMixinEntity)entity;
    }

    public static EntitySnapshot createSnapshot(net.minecraft.entity.Entity entity) {
        return EntityUtil.fromNative(entity).createSnapshot();
    }

    public static void changeWorld(net.minecraft.entity.Entity entity, Location<World> location, int currentDim, int targetDim) {
        MinecraftServer mcServer = SpongeImpl.getServer();
        WorldServer fromWorld = mcServer.func_71218_a(currentDim);
        WorldServer toWorld = mcServer.func_71218_a(targetDim);
        if (entity instanceof EntityPlayer) {
            fromWorld.func_73039_n().func_72787_a((EntityPlayerMP)entity);
            fromWorld.func_184164_w().func_72695_c((EntityPlayerMP)entity);
            mcServer.func_184103_al().func_181057_v().remove(entity);
        } else {
            fromWorld.func_73039_n().func_72790_b(entity);
        }
        entity.func_184210_p();
        entity.field_70170_p.func_72973_f(entity);
        entity.field_70128_L = false;
        entity.field_71093_bK = targetDim;
        entity.func_70080_a(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
        while (!toWorld.func_184144_a(entity, entity.func_174813_aQ()).isEmpty() && entity.field_70163_u < 256.0) {
            entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
        }
        toWorld.func_72863_F().func_186028_c((int)entity.field_70165_t >> 4, (int)entity.field_70161_v >> 4);
        if (entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).field_71135_a != null) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entity;
            int toDimensionId = WorldManager.getClientDimensionId(entityPlayerMP, (net.minecraft.world.World)toWorld);
            if (((IMixinEntityPlayerMP)entityPlayerMP).usesCustomClient()) {
                WorldManager.sendDimensionRegistration(entityPlayerMP, toWorld.field_73011_w);
            } else if (fromWorld != toWorld && fromWorld.field_73011_w.func_186058_p() == toWorld.field_73011_w.func_186058_p()) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketRespawn(toDimensionId >= 0 ? -1 : 0, toWorld.func_175659_aa(), toWorld.func_72912_H().func_76067_t(), entityPlayerMP.field_71134_c.func_73081_b()));
            }
            ((IMixinNetHandlerPlayServer)entityPlayerMP.field_71135_a).setLastMoveLocation(null);
            entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketRespawn(toDimensionId, toWorld.func_175659_aa(), toWorld.func_72912_H().func_76067_t(), entityPlayerMP.field_71134_c.func_73081_b()));
            entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketServerDifficulty(toWorld.func_175659_aa(), toWorld.func_72912_H().func_176123_z()));
            SpongeImpl.getServer().func_184103_al().func_187243_f(entityPlayerMP);
            entity.func_70029_a((net.minecraft.world.World)toWorld);
            entityPlayerMP.field_71135_a.func_147364_a(entityPlayerMP.field_70165_t, entityPlayerMP.field_70163_u, entityPlayerMP.field_70161_v, entityPlayerMP.field_70177_z, entityPlayerMP.field_70125_A);
            entityPlayerMP.func_70095_a(false);
            mcServer.func_184103_al().func_72354_b(entityPlayerMP, toWorld);
            toWorld.func_184164_w().func_72683_a(entityPlayerMP);
            toWorld.func_72838_d((net.minecraft.entity.Entity)entityPlayerMP);
            mcServer.func_184103_al().func_181057_v().add(entityPlayerMP);
            entityPlayerMP.field_71134_c.func_73080_a(toWorld);
            entityPlayerMP.func_71116_b();
            entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketEntityStatus((net.minecraft.entity.Entity)entityPlayerMP, toWorld.func_82736_K().func_82766_b("reducedDebugInfo") ? (byte)22 : 23));
            ((IMixinEntityPlayerMP)entityPlayerMP).refreshXpHealthAndFood();
            for (Object effect : entityPlayerMP.func_70651_bq()) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(entityPlayerMP.func_145782_y(), (PotionEffect)effect));
            }
            entityPlayerMP.func_71016_p();
        } else {
            entity.func_70029_a((net.minecraft.world.World)toWorld);
            toWorld.func_72838_d(entity);
        }
        fromWorld.func_82742_i();
        toWorld.func_82742_i();
    }

    private static void adjustEntityPostionForTeleport(IMixinPlayerList playerList, net.minecraft.entity.Entity entity, WorldServer fromWorld, WorldServer toWorld) {
        fromWorld.field_72984_F.func_76320_a("moving");
        WorldProvider pOld = fromWorld.field_73011_w;
        WorldProvider pNew = toWorld.field_73011_w;
        double moveFactor = playerList.getMovementFactor(pOld) / playerList.getMovementFactor(pNew);
        double x = entity.field_70165_t * moveFactor;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v * moveFactor;
        if (pNew instanceof WorldProviderEnd) {
            BlockPos blockpos = pOld instanceof WorldProviderEnd ? toWorld.func_175694_M() : toWorld.func_180504_m();
            x = blockpos.func_177958_n();
            y = blockpos.func_177956_o();
            z = blockpos.func_177952_p();
            entity.func_70012_b(x, y, z, 90.0f, 0.0f);
        }
        if (!(pOld instanceof WorldProviderEnd)) {
            fromWorld.field_72984_F.func_76320_a("placing");
            x = MathHelper.func_76125_a((int)((int)x), (int)-29999872, (int)29999872);
            z = MathHelper.func_76125_a((int)((int)z), (int)-29999872, (int)29999872);
            if (entity.func_70089_S()) {
                entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            }
            fromWorld.field_72984_F.func_76319_b();
        }
        if (entity.func_70089_S()) {
            fromWorld.func_72866_a(entity, false);
        }
        fromWorld.field_72984_F.func_76319_b();
    }

    @Nullable
    public static EntityItem entityOnDropItem(net.minecraft.entity.Entity entity, ItemStack itemStack, float offsetY) {
        return EntityUtil.entityOnDropItem(entity, itemStack, offsetY, entity.field_70165_t, entity.field_70161_v);
    }

    @Nullable
    public static EntityItem entityOnDropItem(net.minecraft.entity.Entity entity, ItemStack itemStack, float offsetY, double xPos, double zPos) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        IMixinEntity mixinEntity = EntityUtil.toMixin(entity);
        double posX = xPos;
        double posY = entity.field_70163_u + (double)offsetY;
        double posZ = zPos;
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(itemStack);
        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
        original.add(snapshot);
        PhaseData peek = PhaseTracker.getInstance().getCurrentPhaseData();
        IPhaseState<?> currentState = peek.state;
        PhaseContext<?> phaseContext = peek.context;
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            ItemStack item = EntityUtil.throwDropItemAndConstructEvent(mixinEntity, posX, posY, posZ, snapshot, original, frame);
            if (item == null || item.func_190926_b()) {
                EntityItem entityItem = null;
                return entityItem;
            }
            EntityItem entityitem = new EntityItem(entity.field_70170_p, posX, posY, posZ, item);
            entityitem.func_174869_p();
            if (currentState.spawnItemOrCapture(phaseContext, entity, entityitem)) {
                EntityItem entityItem = entityitem;
                return entityItem;
            }
            EntityUtil.processEntitySpawn(EntityUtil.fromNative((net.minecraft.entity.Entity)entityitem), Optional::empty);
            EntityItem entityItem = entityitem;
            return entityItem;
        }
    }

    @Nullable
    public static EntityItem playerDropItem(IMixinEntityPlayer mixinPlayer, ItemStack droppedItem, boolean dropAround, boolean traceItem) {
        mixinPlayer.shouldRestoreInventory(false);
        EntityPlayer player = EntityUtil.toNative(mixinPlayer);
        double posX = player.field_70165_t;
        double posY = player.field_70163_u - 0.3 + (double)player.func_70047_e();
        double posZ = player.field_70161_v;
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(droppedItem);
        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
        original.add(snapshot);
        PhaseData peek = PhaseTracker.getInstance().getCurrentPhaseData();
        IPhaseState<?> currentState = peek.state;
        PhaseContext<?> phaseContext = peek.context;
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            ItemStack item = EntityUtil.throwDropItemAndConstructEvent(mixinPlayer, posX, posY, posZ, snapshot, original, frame);
            if (item == null || item.func_190926_b()) {
                EntityItem entityItem = null;
                return entityItem;
            }
            EntityItem entityitem = new EntityItem(player.field_70170_p, posX, posY, posZ, droppedItem);
            entityitem.func_174867_a(40);
            if (traceItem) {
                entityitem.func_145799_b(player.func_70005_c_());
            }
            Random random = mixinPlayer.getRandom();
            if (dropAround) {
                float f = random.nextFloat() * 0.5f;
                float f1 = random.nextFloat() * ((float)Math.PI * 2);
                entityitem.field_70159_w = -MathHelper.func_76126_a((float)f1) * f;
                entityitem.field_70179_y = MathHelper.func_76134_b((float)f1) * f;
                entityitem.field_70181_x = 0.2f;
            } else {
                float f2 = 0.3f;
                entityitem.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
                entityitem.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
                entityitem.field_70181_x = -MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
                float f3 = random.nextFloat() * ((float)Math.PI * 2);
                f2 = 0.02f * random.nextFloat();
                entityitem.field_70159_w += Math.cos(f3) * (double)f2;
                entityitem.field_70181_x += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
                entityitem.field_70179_y += Math.sin(f3) * (double)f2;
            }
            if (currentState.spawnItemOrCapture(phaseContext, (net.minecraft.entity.Entity)EntityUtil.toNative(mixinPlayer), entityitem)) {
                EntityItem f2 = entityitem;
                return f2;
            }
            ItemStack itemstack = EntityUtil.dropItemAndGetStack(player, entityitem);
            if (traceItem) {
                if (!itemstack.func_190926_b()) {
                    player.func_71064_a(StatList.func_188058_e((Item)itemstack.func_77973_b()), droppedItem.func_190916_E());
                }
                player.func_71029_a(StatList.field_75952_v);
            }
            EntityItem entityItem = entityitem;
            return entityItem;
        }
    }

    @Nullable
    public static ItemStack throwDropItemAndConstructEvent(IMixinEntity entity, double posX, double posY, double posZ, ItemStackSnapshot snapshot, List<ItemStackSnapshot> original, CauseStackManager.StackFrame frame) {
        ItemStack item;
        IMixinEntityPlayer mixinPlayer = entity instanceof IMixinEntityPlayer ? (IMixinEntityPlayer)entity : null;
        frame.pushCause(entity);
        DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(frame.getCurrentCause(), (List)ImmutableList.of((Object)snapshot), original);
        SpongeImpl.postEvent(dropEvent);
        if (dropEvent.isCancelled()) {
            if (mixinPlayer != null) {
                mixinPlayer.shouldRestoreInventory(true);
            }
            return null;
        }
        if (dropEvent.getDroppedItems().isEmpty()) {
            return null;
        }
        Transform<World> suggested = new Transform<World>(entity.getWorld(), new Vector3d(posX, posY, posZ));
        frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), EntityTypes.ITEM, suggested);
        frame.removeContext(EventContextKeys.SPAWN_TYPE);
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            if (mixinPlayer != null) {
                mixinPlayer.shouldRestoreInventory(true);
            }
            return null;
        }
        ItemStack itemStack = item = event.isCancelled() ? null : ItemStackUtil.fromSnapshotToNative(dropEvent.getDroppedItems().get(0));
        if (item == null) {
            if (mixinPlayer != null) {
                mixinPlayer.shouldRestoreInventory(true);
            }
            return null;
        }
        return item;
    }

    private static Vector3d createDropMotion(boolean dropAround, EntityPlayer player, Random random) {
        double y;
        double z;
        double x;
        if (dropAround) {
            float f = random.nextFloat() * 0.5f;
            float f1 = random.nextFloat() * ((float)Math.PI * 2);
            x = -MathHelper.func_76126_a((float)f1) * f;
            z = MathHelper.func_76134_b((float)f1) * f;
            y = 0.2f;
        } else {
            float f2 = 0.3f;
            x = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
            z = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
            y = -MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
            float f3 = random.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * random.nextFloat();
            x += Math.cos(f3) * (double)f2;
            y += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
            z += Math.sin(f3) * (double)f2;
        }
        return new Vector3d(x, y, z);
    }

    private static ItemStack dropItemAndGetStack(EntityPlayer player, EntityItem item) {
        ItemStack stack = item.func_92059_d();
        player.field_70170_p.func_72838_d((net.minecraft.entity.Entity)item);
        return stack;
    }

    public static Optional<EntityType> fromNameToType(String name) {
        Class<? extends net.minecraft.entity.Entity> clazz = SpongeImplHooks.getEntityClass(new ResourceLocation(name));
        if (clazz == null) {
            return Optional.empty();
        }
        return Optional.of(EntityTypeRegistryModule.getInstance().getForClass((Class)clazz));
    }

    public static Optional<EntityType> fromLocationToType(ResourceLocation location) {
        Class<? extends net.minecraft.entity.Entity> clazz = SpongeImplHooks.getEntityClass(location);
        if (clazz == null) {
            return Optional.empty();
        }
        return Optional.of(EntityTypeRegistryModule.getInstance().getForClass((Class)clazz));
    }

    public static EntityArchetype archetype(EntityType type) {
        return new SpongeEntityArchetypeBuilder().type(type).build();
    }

    static final class EntityTrace {
        net.minecraft.entity.Entity entity;
        Vec3d location;
        double distance;

        EntityTrace(double entityDistance) {
            this.distance = entityDistance;
        }

        RayTraceResult asRayTraceResult() {
            return new RayTraceResult(this.entity, this.location);
        }
    }
}

