/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.world.WorldUtil;

final class BlockDecayPhaseState
extends BlockPhaseState {
    public final BiConsumer<CauseStackManager.StackFrame, GeneralizedContext> BLOCK_DECAY_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        LocatableBlock locatable = context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
        frame.pushCause(locatable);
    });

    BlockDecayPhaseState() {
    }

    @Override
    public GeneralizedContext createPhaseContext() {
        return (GeneralizedContext)super.createPhaseContext().addCaptures();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, GeneralizedContext> getFrameModifier() {
        return this.BLOCK_DECAY_MODIFIER;
    }

    @Override
    public void unwind(GeneralizedContext context) {
        LocatableBlock locatable = context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
        Location<World> worldLocation = locatable.getLocation();
        IMixinWorldServer mixinWorld = (IMixinWorldServer)((Object)worldLocation.getExtent());
        context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, context));
        context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            List<Entity> entities = items.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callSpawnEntity(entities, context);
        });
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callSpawnEntity(entities, context);
        });
        context.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(drops -> {
            List items = drops.stream().map(drop -> drop.create(WorldUtil.asNative(mixinWorld))).collect(Collectors.toList());
            List entities = items;
            if (!entities.isEmpty()) {
                DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    EntityUtil.processEntitySpawnsFromEvent(context, event);
                }
            }
        });
    }
}

