/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.world.WorldUtil;

final class BlockDropItemsPhaseState
extends BlockPhaseState {
    private final BiConsumer<CauseStackManager.StackFrame, GeneralizedContext> BLOCK_DROP_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        BlockSnapshot blockSnapshot = ctx.getSource(BlockSnapshot.class).orElseThrow(TrackingUtil.throwWithContext("Could not find a block dropping items!", ctx));
        frame.pushCause(blockSnapshot);
        frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
    });

    BlockDropItemsPhaseState() {
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, GeneralizedContext> getFrameModifier() {
        return this.BLOCK_DROP_MODIFIER;
    }

    @Override
    public GeneralizedContext createPhaseContext() {
        return (GeneralizedContext)((GeneralizedContext)super.createPhaseContext().addBlockCaptures()).addEntityCaptures();
    }

    @Override
    public void unwind(GeneralizedContext context) {
        context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
            for (EntityItem item : items) {
                entities.add(EntityUtil.fromNative((Entity)item));
            }
            SpongeCommonEventFactory.callDropItemDestruct(entities, context);
        });
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> SpongeCommonEventFactory.callSpawnEntity(entities, context));
        BlockSnapshot blockSnapshot = context.getSource(BlockSnapshot.class).orElseThrow(TrackingUtil.throwWithContext("Could not find a block dropping items!", context));
        Location<World> worldLocation = blockSnapshot.getLocation().get();
        IMixinWorldServer mixinWorld = (IMixinWorldServer)((Object)worldLocation.getExtent());
        context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> {
            TrackingUtil.processBlockCaptures(blocks, this, context);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
        });
        context.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(drops -> {
            List<org.spongepowered.api.entity.Entity> items = drops.stream().map(drop -> drop.create(WorldUtil.asNative(mixinWorld))).collect(Collectors.toList());
            List<org.spongepowered.api.entity.Entity> entities = items;
            if (!entities.isEmpty()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                SpongeCommonEventFactory.callDropItemCustom(entities, context);
            }
            drops.clear();
        });
        context.getBlockDropSupplier().acceptAndClearIfNotEmpty(drops -> {
            for (BlockPos key : drops.asMap().keySet()) {
                List values = drops.get((Object)key);
                if (values.isEmpty()) continue;
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                TrackingUtil.spawnItemDataForBlockDrops(values, blockSnapshot, context);
            }
        });
    }

    @Override
    public boolean tracksBlockSpecificDrops(GeneralizedContext context) {
        return true;
    }
}

