/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.entity;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.entity.BasicEntityContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhaseState;
import org.spongepowered.common.registry.type.event.SpawnTypeRegistryModule;

final class DeathUpdateState
extends EntityPhaseState<BasicEntityContext> {
    DeathUpdateState() {
    }

    @Override
    public BasicEntityContext createPhaseContext() {
        return (BasicEntityContext)((BasicEntityContext)new BasicEntityContext(this).addCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(BasicEntityContext context) {
        Entity dyingEntity = context.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Dying entity not found!", context));
        context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            DamageSource damageSource = context.getDamageSource();
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                if (damageSource != null) {
                    frame.pushCause(damageSource);
                }
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DISPENSE);
                frame.pushCause(dyingEntity);
                SpongeCommonEventFactory.callDropItemCustom(items, context);
            }
        });
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            List<Entity> other;
            List<Entity> experience = entities.stream().filter(entity -> entity instanceof ExperienceOrb).collect(Collectors.toList());
            if (!experience.isEmpty()) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(dyingEntity);
                    frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                    SpongeCommonEventFactory.callSpawnEntity(experience, context);
                }
            }
            if (!(other = entities.stream().filter(entity -> !(entity instanceof ExperienceOrb)).collect(Collectors.toList())).isEmpty()) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(dyingEntity);
                    frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypeRegistryModule.ENTITY_DEATH);
                    SpongeCommonEventFactory.callSpawnEntity(other, context);
                }
            }
        });
        context.getPerEntityItemDropSupplier().acceptAndClearIfNotEmpty(map -> {
            if (map.isEmpty()) {
                return;
            }
            PrettyPrinter printer = new PrettyPrinter(80);
            printer.add("Processing Entity Death Updates Spawning").centre().hr();
            printer.add("Entity Dying: " + dyingEntity);
            printer.add("The item stacks captured are: ");
            for (Map.Entry entry : map.asMap().entrySet()) {
                printer.add("  - Entity with UUID: %s", entry.getKey());
                for (ItemDropData stack : (Collection)entry.getValue()) {
                    printer.add("    - %s", stack);
                }
            }
            printer.trace(System.err);
        });
        context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, context));
    }
}

