/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IEntitySpecificItemDropsState;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.event.tracking.phase.general.CommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.entity.player.IMixinInventoryPlayer;
import org.spongepowered.common.world.WorldManager;

final class CommandState
extends GeneralState<CommandPhaseContext>
implements IEntitySpecificItemDropsState<CommandPhaseContext> {
    private final BiConsumer<CauseStackManager.StackFrame, CommandPhaseContext> COMMAND_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> ctx.getSource(Object.class).ifPresent(frame::pushCause));

    CommandState() {
    }

    @Override
    public CommandPhaseContext createPhaseContext() {
        return new CommandPhaseContext(this);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, CommandPhaseContext> getFrameModifier() {
        return this.COMMAND_MODIFIER;
    }

    @Override
    public boolean canSwitchTo(IPhaseState<?> state) {
        return state instanceof BlockPhaseState;
    }

    @Override
    public boolean ignoresItemPreMerging() {
        return true;
    }

    @Override
    public void associateNeighborStateNotifier(CommandPhaseContext context, BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        context.getSource(Player.class).ifPresent(player -> ((IMixinChunk)minecraftWorld.func_175726_f(notifyPos)).addTrackedBlockPosition(block, notifyPos, (User)player, PlayerTracker.Type.NOTIFIER));
    }

    @Override
    public void unwind(CommandPhaseContext phaseContext) {
        Optional<EntityPlayer> playerSource = phaseContext.getSource(EntityPlayer.class);
        CauseStackManager csm = Sponge.getCauseStackManager();
        if (playerSource.isPresent()) {
            ((IMixinInventoryPlayer)playerSource.get().field_71071_by).setCapture(false);
            List<SlotTransaction> list2 = ((IMixinInventoryPlayer)playerSource.get().field_71071_by).getCapturedTransactions();
            if (!list2.isEmpty()) {
                ChangeInventoryEvent event = SpongeEventFactory.createChangeInventoryEvent(csm.getCurrentCause(), (Inventory)playerSource.get().field_71071_by, list2);
                SpongeImpl.postEvent(event);
                PacketPhaseUtil.handleSlotRestore(playerSource.get(), null, list2, event.isCancelled());
                list2.clear();
            }
        }
        CommandSource sender = phaseContext.getSource(CommandSource.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a Command Sender, but none found!", phaseContext));
        phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(list -> TrackingUtil.processBlockCaptures(list, this, phaseContext));
        phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            csm.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            SpongeCommonEventFactory.callSpawnEntity(entities, phaseContext);
        });
        phaseContext.getPerEntityItemDropSupplier().acceptAndClearIfNotEmpty(uuidItemStackMultimap -> {
            for (Map.Entry entry : uuidItemStackMultimap.asMap().entrySet()) {
                Optional<org.spongepowered.api.entity.Entity> affectedEntity;
                UUID key = (UUID)entry.getKey();
                Entity foundEntity = null;
                for (WorldServer worldServer : WorldManager.getWorlds()) {
                    Entity entityFromUuid = worldServer.func_175733_a(key);
                    if (entityFromUuid == null) continue;
                    foundEntity = entityFromUuid;
                    break;
                }
                if (!(affectedEntity = Optional.ofNullable((org.spongepowered.api.entity.Entity)foundEntity)).isPresent()) continue;
                Collection itemStacks = (Collection)entry.getValue();
                if (itemStacks.isEmpty()) {
                    return;
                }
                ArrayList items = new ArrayList();
                items.addAll(itemStacks);
                itemStacks.clear();
                WorldServer minecraftWorld = EntityUtil.getMinecraftWorld(affectedEntity.get());
                if (items.isEmpty()) continue;
                csm.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                List itemEntities = items.stream().map(data -> data.create(minecraftWorld)).map(EntityUtil::fromNative).collect(Collectors.toList());
                csm.pushCause(affectedEntity.get());
                DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(csm.getCurrentCause(), itemEntities);
                SpongeImpl.postEvent(destruct);
                csm.popCause();
                if (destruct.isCancelled()) continue;
                boolean isPlayer = sender instanceof Player;
                Player player = isPlayer ? (Player)sender : null;
                EntityUtil.processEntitySpawnsFromEvent(destruct, () -> Optional.ofNullable(isPlayer ? player.getUniqueId() : null));
            }
        });
    }

    @Override
    public boolean spawnEntityOrCapture(CommandPhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            entities.add(entity);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
            return bl;
        }
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }
}

