/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.CapturedSupplier;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;
import org.spongepowered.common.event.tracking.phase.general.UnwindingPhaseContext;
import org.spongepowered.common.world.BlockChange;

public final class PostState
extends GeneralState<UnwindingPhaseContext> {
    private static void postBlockAddedSpawns(UnwindingPhaseContext postContext, IPhaseState<?> unwindingState, PhaseContext<?> unwindingPhaseContext, CapturedSupplier<BlockSnapshot> capturedBlockSupplier) {
        postContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            ArrayList<Entity> capturedEntities = new ArrayList<Entity>((Collection<Entity>)entities);
            unwindingState.postProcessSpawns(unwindingPhaseContext, capturedEntities);
        });
        capturedBlockSupplier.acceptAndClearIfNotEmpty(blocks -> {
            ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>((Collection<BlockSnapshot>)blocks);
            TrackingUtil.processBlockCaptures(blockSnapshots, GeneralPhase.Post.UNWINDING, postContext);
        });
    }

    @Override
    public UnwindingPhaseContext createPhaseContext() {
        throw new UnsupportedOperationException("Use UnwindingPhaseContext#unwind(IPhaseState, PhaseContext)! Cannot create a context based on Post state!");
    }

    @Override
    public boolean canSwitchTo(IPhaseState<?> state) {
        return state != this;
    }

    @Override
    public boolean requiresPost() {
        return false;
    }

    @Override
    public boolean ignoresBlockUpdateTick(UnwindingPhaseContext context) {
        return true;
    }

    @Override
    public boolean ignoresScheduledUpdates() {
        return false;
    }

    @Override
    public boolean alreadyCapturingEntitySpawns() {
        return true;
    }

    @Override
    public boolean alreadyCapturingEntityTicks() {
        return true;
    }

    @Override
    public boolean alreadyCapturingTileTicks() {
        return true;
    }

    @Override
    public boolean alreadyProcessingBlockItemDrops() {
        return true;
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, UnwindingPhaseContext context) {
        IPhaseState<?> phaseState = context.getUnwindingState();
        Object unwinding = context.getUnwindingContext();
        phaseState.appendContextPreExplosion(explosionContext, unwinding);
    }

    @Override
    public void associateNeighborStateNotifier(UnwindingPhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        IPhaseState<?> unwindingState = context.getUnwindingState();
        Object unwindingContext = context.getUnwindingContext();
        unwindingState.associateNeighborStateNotifier(unwindingContext, sourcePos, block, notifyPos, minecraftWorld, notifier);
    }

    @Override
    public void unwind(UnwindingPhaseContext context) {
        IPhaseState<?> unwindingState = context.getUnwindingState();
        Object unwindingContext = context.getUnwindingContext();
        this.postDispatch(unwindingState, (PhaseContext<?>)unwindingContext, context);
    }

    private void postDispatch(IPhaseState<?> unwindingState, PhaseContext<?> unwindingContext, UnwindingPhaseContext postContext) {
        List<BlockSnapshot> contextBlocks = postContext.getCapturedBlocksOrEmptyList();
        List<Entity> contextEntities = postContext.getCapturedEntitiesOrEmptyList();
        List<EntityItem> contextItems = postContext.getCapturedItemsOrEmptyList();
        if (contextBlocks.isEmpty() && contextEntities.isEmpty() && contextItems.isEmpty()) {
            return;
        }
        if (!contextBlocks.isEmpty()) {
            ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>(contextBlocks);
            contextBlocks.clear();
            TrackingUtil.processBlockCaptures(blockSnapshots, this, postContext);
        }
        if (!contextEntities.isEmpty()) {
            ArrayList<Entity> entities = new ArrayList<Entity>(contextEntities);
            contextEntities.clear();
            unwindingState.postProcessSpawns(unwindingContext, entities);
        }
        if (!contextItems.isEmpty()) {
            ArrayList<EntityItem> items = new ArrayList<EntityItem>(contextItems);
            contextItems.clear();
            SpongeCommonEventFactory.callSpawnEntity(items, unwindingContext);
        }
    }

    @Override
    public boolean spawnEntityOrCapture(UnwindingPhaseContext context, Entity entity, int chunkX, int chunkZ) {
        return context.getCapturedEntities().add(entity);
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public void performOnBlockAddedSpawns(UnwindingPhaseContext context) {
        PostState.postBlockAddedSpawns(context, context.getUnwindingState(), context.getUnwindingContext(), context.getCapturedBlockSupplier());
    }

    @Override
    public void performPostBlockNotificationsAndNeighborUpdates(UnwindingPhaseContext context, int depth) {
        if (PhaseTracker.checkMaxBlockProcessingDepth(this, context, depth)) {
            return;
        }
        context.setBulkBlockCaptures(false);
        CapturedSupplier<BlockSnapshot> capturedBlockSupplier = context.getCapturedBlockSupplier();
        capturedBlockSupplier.acceptAndClearIfNotEmpty(blocks -> {
            ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>((Collection<BlockSnapshot>)blocks);
            blocks.clear();
            TrackingUtil.processBlockCaptures(blockSnapshots, this, context, depth);
        });
    }

    @Override
    public boolean doesBulkBlockCapture(UnwindingPhaseContext context) {
        return context.allowsBulkBlockCaptures();
    }

    @Override
    public boolean alreadyCapturingBlockTicks(UnwindingPhaseContext context) {
        return true;
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<BlockSnapshot> snapshotTransaction, UnwindingPhaseContext context) {
        IPhaseState<?> unwindingState = context.getUnwindingState();
        Object unwindingContext = context.getUnwindingContext();
        unwindingState.postBlockTransactionApplication(blockChange, snapshotTransaction, unwindingContext);
    }
}

