/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.InventoryPacketContext;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class DropInventoryState
extends BasicInventoryPacketState {
    @Override
    public void unwind(InventoryPacketContext context) {
        EntityPlayerMP player = context.getPacketPlayer();
        ItemStack usedStack = context.getItemUsed();
        ItemStackSnapshot usedSnapshot = ItemStackUtil.snapshotOf(usedStack);
        org.spongepowered.api.entity.Entity spongePlayer = EntityUtil.fromNative((Entity)player);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(spongePlayer);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, context));
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem item : items) {
                    entities.add(EntityUtil.fromNative((Entity)item));
                }
                DropItemEvent.Dispense dropItemEvent = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(dropItemEvent);
                if (!dropItemEvent.isCancelled()) {
                    DropInventoryState.processSpawnedEntities(player, dropItemEvent);
                }
            });
            IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
            mixinContainer.setCaptureInventory(false);
            mixinContainer.getCapturedTransactions().clear();
        }
    }
}

