/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.event.tracking.phase.packet.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.InventoryPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;

final class DropItemOutsideWindowState
extends BasicInventoryPacketState {
    DropItemOutsideWindowState() {
        super(PacketPhase.MODE_CLICK | 1 | 2 | 0x20000);
    }

    @Override
    public boolean doesCaptureEntityDrops(InventoryPacketContext context) {
        return true;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, InventoryPacketContext context) {
        super.populateContext(playerMP, packet, context);
    }

    @Override
    public ClickInventoryEvent createInventoryEvent(EntityPlayerMP playerMP, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<Entity> capturedEntities, int usedButton) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            for (Entity currentEntity : capturedEntities) {
                currentEntity.setCreator(playerMP.func_110124_au());
            }
            ClickInventoryEvent.Drop.Outside outside = usedButton == 0 ? SpongeEventFactory.createClickInventoryEventDropOutsidePrimary(frame.getCurrentCause(), transaction, capturedEntities, openContainer, slotTransactions) : SpongeEventFactory.createClickInventoryEventDropOutsideSecondary(frame.getCurrentCause(), transaction, capturedEntities, openContainer, slotTransactions);
            return outside;
        }
    }

    @Override
    public boolean ignoresItemPreMerging() {
        return true;
    }
}

