/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

public abstract class PacketState<P extends PacketContext<P>>
implements IPhaseState<P> {
    private BiConsumer<CauseStackManager.StackFrame, P> BASIC_PACKET_MODIFIER = IPhaseState.super.getFrameModifier().andThen((frame, ctx) -> {
        if (ctx.packetPlayer != null) {
            frame.pushCause(ctx.packetPlayer);
        }
    });
    private final String className = this.getClass().getSimpleName();

    PacketState() {
    }

    protected static void processSpawnedEntities(EntityPlayerMP player, SpawnEntityEvent event) {
        List<Entity> entities = event.getEntities();
        PacketState.processEntities(player, entities);
    }

    protected static void processEntities(EntityPlayerMP player, Collection<Entity> entities) {
        for (Entity entity : entities) {
            EntityUtil.processEntitySpawn(entity, () -> Optional.of(player.func_110124_au()));
        }
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, P> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public final TrackingPhase getPhase() {
        return TrackingPhases.PACKET;
    }

    @Override
    public void unwind(P phaseContext) {
        ((PhaseContext)phaseContext).getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, phaseContext));
    }

    public boolean matches(int packetState) {
        return false;
    }

    @Override
    public void appendNotifierToBlockEvent(P context, IMixinWorldServer mixinWorldServer, BlockPos pos, IMixinBlockEventData blockEvent) {
    }

    @Override
    public void associateNeighborStateNotifier(P unwindingContext, BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        Player player = ((PacketContext)unwindingContext).getSpongePlayer();
        Chunk chunk = minecraftWorld.func_175726_f(notifyPos);
        ((IMixinChunk)chunk).setBlockNotifier(notifyPos, player.getUniqueId());
    }

    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, P context) {
    }

    public boolean isPacketIgnored(Packet<?> packetIn, EntityPlayerMP packetPlayer) {
        return false;
    }

    @Override
    public boolean ignoresItemPreMerging() {
        return false;
    }

    @Override
    public boolean doesCaptureEntityDrops(P context) {
        return false;
    }

    @Override
    public boolean doesBulkBlockCapture(P context) {
        return true;
    }

    @Override
    public void postProcessSpawns(P context, ArrayList<Entity> entities) {
        Player player = ((PacketContext)context).getSpongePlayer();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            frame.pushCause(player);
            SpongeCommonEventFactory.callSpawnEntity(entities, context);
        }
    }

    @Override
    public boolean spawnEntityOrCapture(P context, Entity entity, int chunkX, int chunkZ) {
        return this.shouldCaptureEntity() ? ((PhaseContext)context).getCapturedEntities().add(entity) : this.spawnEntity(context, entity, chunkX, chunkZ);
    }

    public boolean shouldCaptureEntity() {
        return false;
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return this.shouldCaptureEntity();
    }

    public boolean spawnEntity(P context, Entity entity, int chunkX, int chunkZ) {
        Player player = ((PhaseContext)context).getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a player", context));
        ArrayList<Entity> entities = new ArrayList<Entity>(1);
        entities.add(entity);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            frame.addContext(EventContextKeys.NOTIFIER, player);
            frame.addContext(EventContextKeys.OWNER, player);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
            return bl;
        }
    }

    public String toString() {
        return this.getPhase() + "{" + this.className + "}";
    }
}

