/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlaceRecipe;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.crafting.CraftingOutput;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.phase.packet.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.InventoryPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class PlaceRecipePacketState
extends BasicInventoryPacketState {
    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, InventoryPacketContext context) {
        ((IMixinContainer)playerMP.field_71070_bA).setCaptureInventory(true);
        ((IMixinContainer)playerMP.field_71070_bA).setFirePreview(false);
    }

    @Override
    public void unwind(InventoryPacketContext context) {
        CPacketPlaceRecipe packet = (CPacketPlaceRecipe)context.getPacket();
        boolean shift = packet.func_194319_c();
        IRecipe recipe = packet.func_194317_b();
        EntityPlayerMP player = context.getPacketPlayer();
        ((IMixinContainer)player.field_71070_bA).detectAndSendChanges(true);
        ((IMixinContainer)player.field_71070_bA).setCaptureInventory(false);
        ((IMixinContainer)player.field_71070_bA).setFirePreview(true);
        Object craftInv = ((Inventory)player.field_71070_bA).query(QueryOperationTypes.INVENTORY_TYPE.of(CraftingInventory.class));
        if (!(craftInv instanceof CraftingInventory)) {
            SpongeImpl.getLogger().warn("Detected crafting without a InventoryCrafting!? Crafting Event will not fire.");
            return;
        }
        List<SlotTransaction> previewTransactions = ((IMixinContainer)player.field_71070_bA).getPreviewTransactions();
        if (previewTransactions.isEmpty()) {
            CraftingOutput slot = ((CraftingInventory)craftInv).getResult();
            SlotTransaction st = new SlotTransaction(slot, ItemStackSnapshot.NONE, ItemStackUtil.snapshotOf(slot.peek().orElse(ItemStack.empty())));
            previewTransactions.add(st);
        }
        SpongeCommonEventFactory.callCraftEventPre((EntityPlayer)player, (CraftingInventory)craftInv, previewTransactions.get(0), (CraftingRecipe)recipe, player.field_71070_bA, previewTransactions);
        previewTransactions.clear();
        org.spongepowered.api.entity.Entity spongePlayer = EntityUtil.fromNative((Entity)player);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(spongePlayer);
            frame.pushCause(player.field_71070_bA);
            List<SlotTransaction> transactions = ((IMixinContainer)player.field_71070_bA).getCapturedTransactions();
            ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
            Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(cursor, cursor);
            ClickInventoryEvent.Recipe event = shift ? SpongeEventFactory.createClickInventoryEventRecipeAll(frame.getCurrentCause(), cursorTransaction, (Recipe)recipe, (Container)player.field_71070_bA, transactions) : SpongeEventFactory.createClickInventoryEventRecipeSingle(frame.getCurrentCause(), cursorTransaction, (Recipe)recipe, (Container)player.field_71070_bA, transactions);
            SpongeImpl.postEvent(event);
            if (event.isCancelled() || !event.getCursorTransaction().isValid()) {
                PacketPhaseUtil.handleCustomCursor(player, event.getCursorTransaction().getOriginal());
            } else {
                PacketPhaseUtil.handleCustomCursor(player, event.getCursorTransaction().getFinal());
            }
            PacketPhaseUtil.handleSlotRestore((EntityPlayer)player, player.field_71070_bA, event.getTransactions(), event.isCancelled());
            event.getTransactions().clear();
        }
    }
}

