/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.player;

import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;

final class PlayerLogoutPhaseState
implements IPhaseState<GeneralizedContext> {
    private final String className = this.getClass().getSimpleName();

    PlayerLogoutPhaseState() {
    }

    @Override
    public TrackingPhase getPhase() {
        return TrackingPhases.PLAYER;
    }

    @Override
    public GeneralizedContext createPhaseContext() {
        return new GeneralizedContext(this);
    }

    @Override
    public void unwind(GeneralizedContext phaseContext) {
        Player player = phaseContext.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing a player leaving, but we're not!", phaseContext));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> SpongeCommonEventFactory.callDropItemDispense(items, phaseContext));
            phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {});
            phaseContext.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(items -> {
                List<Entity> drops = items.stream().map(drop -> drop.create(EntityUtil.getMinecraftWorld(player))).map(EntityUtil::fromNative).collect(Collectors.toList());
                SpongeCommonEventFactory.callDropItemCustom(drops, phaseContext);
            });
            phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, phaseContext));
        }
    }

    public String toString() {
        return this.getPhase() + "{" + this.className + "}";
    }
}

