/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.BlockEventTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

class BlockEventTickPhaseState
extends TickPhaseState<BlockEventTickContext> {
    BlockEventTickPhaseState() {
    }

    @Override
    public BlockEventTickContext createPhaseContext() {
        return (BlockEventTickContext)((BlockEventTickContext)new BlockEventTickContext().addBlockCaptures()).addEntityCaptures();
    }

    @Override
    public void associateNeighborStateNotifier(BlockEventTickContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        User user = context.getNotifier().orElse(null);
        if (user != null) {
            IMixinChunk mixinChunk = (IMixinChunk)minecraftWorld.func_175726_f(notifyPos);
            mixinChunk.addTrackedBlockPosition(block, notifyPos, user, PlayerTracker.Type.NOTIFIER);
        }
    }

    @Override
    public boolean spawnEntityOrCapture(BlockEventTickContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CUSTOM);
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            entities.add(entity);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
            return bl;
        }
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<BlockSnapshot> snapshotTransaction, BlockEventTickContext context) {
        Block block = (Block)snapshotTransaction.getOriginal().getState().getType();
        Location<World> changedLocation = snapshotTransaction.getOriginal().getLocation().get();
        Vector3d changedPosition = changedLocation.getPosition();
        BlockPos changedBlockPos = VecHelper.toBlockPos(changedPosition);
        IMixinChunk changedMixinChunk = (IMixinChunk)((WorldServer)changedLocation.getExtent()).func_175726_f(changedBlockPos);
        changedMixinChunk.getBlockOwner(changedBlockPos).ifPresent(owner -> changedMixinChunk.addTrackedBlockPosition(block, changedBlockPos, (User)owner, PlayerTracker.Type.OWNER));
        User user = TrackingUtil.getNotifierOrOwnerFromBlock(changedLocation);
        if (user != null) {
            changedMixinChunk.addTrackedBlockPosition(block, changedBlockPos, user, PlayerTracker.Type.NOTIFIER);
        }
    }

    @Override
    public void unwind(BlockEventTickContext context) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CUSTOM);
            context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, context));
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem entity : items) {
                    capturedEntities.add(EntityUtil.fromNative((Entity)entity));
                }
                SpongeCommonEventFactory.callSpawnEntity(capturedEntities, context);
            });
        }
    }

    @Override
    public String toString() {
        return "BlockEventTickPhase";
    }
}

