/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.CombatEntry;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.Ageable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

class EntityTickPhaseState
extends TickPhaseState<EntityTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, EntityTickContext> ENTITY_TICK_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        org.spongepowered.api.entity.Entity tickingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", context));
        frame.pushCause(tickingEntity);
        if (tickingEntity instanceof EntityFallingBlock) {
            context.getOwner().ifPresent(frame::pushCause);
        }
    });
    private String name;

    EntityTickPhaseState(String name) {
        this.name = name;
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, EntityTickContext> getFrameModifier() {
        return this.ENTITY_TICK_MODIFIER;
    }

    @Override
    public void unwind(EntityTickContext phaseContext) {
        org.spongepowered.api.entity.Entity tickingEntity = phaseContext.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", phaseContext));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(tickingEntity);
            this.processCaptures(tickingEntity, phaseContext, frame);
        }
    }

    protected void processCaptures(org.spongepowered.api.entity.Entity tickingEntity, EntityTickContext phaseContext, CauseStackManager.StackFrame frame) {
        phaseContext.addNotifierAndOwnerToCauseStack(frame);
        if (phaseContext.allowsBulkBlockCaptures()) {
            phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blockSnapshots -> {
                if (!TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext)) {
                    EntityUtil.toMixin(tickingEntity).onCancelledBlockChange(phaseContext);
                }
            });
        }
        if (!phaseContext.allowsBulkEntityCaptures()) {
            return;
        }
        phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            ArrayList<org.spongepowered.api.entity.Entity> experience = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
            ArrayList<org.spongepowered.api.entity.Entity> nonExp = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
            ArrayList<org.spongepowered.api.entity.Entity> breeding = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
            ArrayList<org.spongepowered.api.entity.Entity> projectile = new ArrayList<org.spongepowered.api.entity.Entity>(entities.size());
            for (org.spongepowered.api.entity.Entity entity : entities) {
                if (entity instanceof EntityXPOrb) {
                    experience.add(entity);
                    continue;
                }
                if (tickingEntity instanceof Ageable && tickingEntity.getClass() == entity.getClass()) {
                    breeding.add(entity);
                    continue;
                }
                if (entity instanceof Projectile) {
                    projectile.add(entity);
                    continue;
                }
                nonExp.add(entity);
            }
            if (!experience.isEmpty()) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                this.appendContextOfPossibleEntityDeath(tickingEntity, frame);
                SpongeCommonEventFactory.callSpawnEntity(experience, phaseContext);
                frame.removeContext(EventContextKeys.LAST_DAMAGE_SOURCE);
            }
            if (!breeding.isEmpty()) {
                EntityPlayerMP playerInLove;
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BREEDING);
                if (tickingEntity instanceof EntityAnimal && (playerInLove = ((EntityAnimal)tickingEntity).func_191993_do()) != null) {
                    frame.addContext(EventContextKeys.PLAYER, (Player)playerInLove);
                }
                SpongeCommonEventFactory.callSpawnEntity(breeding, phaseContext);
                frame.removeContext(EventContextKeys.PLAYER);
            }
            if (!projectile.isEmpty()) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PROJECTILE);
                SpongeCommonEventFactory.callSpawnEntity(projectile, phaseContext);
                frame.removeContext(EventContextKeys.SPAWN_TYPE);
            }
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PASSIVE);
            SpongeCommonEventFactory.callSpawnEntity(nonExp, phaseContext);
            frame.removeContext(EventContextKeys.SPAWN_TYPE);
        });
        phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
            ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
            for (EntityItem entity : entities) {
                capturedEntities.add(EntityUtil.fromNative((Entity)entity));
            }
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callDropItemCustom(capturedEntities, phaseContext);
            frame.removeContext(EventContextKeys.SPAWN_TYPE);
        });
        phaseContext.getBlockItemDropSupplier().acceptAndClearIfNotEmpty(map -> {
            List<BlockSnapshot> capturedBlocks = phaseContext.getCapturedBlocks();
            for (BlockSnapshot snapshot : capturedBlocks) {
                BlockPos blockPos = VecHelper.toBlockPos(snapshot.getLocation().get());
                List entityItems = map.get((Object)blockPos);
                if (entityItems.isEmpty()) continue;
                frame.pushCause(snapshot);
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                List<org.spongepowered.api.entity.Entity> items = entityItems.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                SpongeCommonEventFactory.callDropItemDestruct(items, phaseContext);
                frame.popCause();
            }
        });
        phaseContext.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(drops -> {
            List<org.spongepowered.api.entity.Entity> items = drops.stream().map(drop -> drop.create(EntityUtil.getMinecraftWorld(tickingEntity))).map(EntityUtil::fromNative).collect(Collectors.toList());
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callDropItemCustom(items, phaseContext);
        });
    }

    private void appendContextOfPossibleEntityDeath(org.spongepowered.api.entity.Entity tickingEntity, CauseStackManager.StackFrame frame) {
        CombatEntry entry;
        if (EntityUtil.isEntityDead(tickingEntity) && tickingEntity instanceof EntityLivingBase && (entry = ((EntityLivingBase)tickingEntity).func_110142_aN().func_94544_f()) != null && entry.field_94569_a != null) {
            frame.addContext(EventContextKeys.LAST_DAMAGE_SOURCE, (DamageSource)entry.field_94569_a);
        }
    }

    @Override
    public EntityTickContext createPhaseContext() {
        return (EntityTickContext)new EntityTickContext(this).addCaptures();
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<BlockSnapshot> transaction, EntityTickContext context) {
        if (blockChange == BlockChange.BREAK) {
            org.spongepowered.api.entity.Entity tickingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).get();
            BlockPos blockPos = VecHelper.toBlockPos(transaction.getOriginal().getPosition());
            for (EntityHanging entityHanging : EntityUtil.findHangingEntities(EntityUtil.getMinecraftWorld(tickingEntity), blockPos)) {
                if (!(entityHanging instanceof EntityItemFrame)) continue;
                EntityItemFrame itemFrame = (EntityItemFrame)entityHanging;
                if (!itemFrame.field_70128_L) {
                    itemFrame.func_146065_b(EntityUtil.toNative(tickingEntity), true);
                }
                itemFrame.func_70106_y();
            }
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, EntityTickContext context) {
        context.getOwner().ifPresent(explosionContext::owner);
        context.getNotifier().ifPresent(explosionContext::notifier);
        org.spongepowered.api.entity.Entity tickingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking entity!", context));
        Sponge.getCauseStackManager().pushCause(tickingEntity);
    }

    @Override
    public boolean spawnEntityOrCapture(EntityTickContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        org.spongepowered.api.entity.Entity tickingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", context));
        if (context.allowsBulkEntityCaptures()) {
            Optional<BlockPos> pos = context.getCaptureBlockPos().getPos();
            if (pos.isPresent()) {
                return context.getPerBlockEntitySpawnSuppplier().get().put((Object)pos.get(), (Object)EntityUtil.toNative(entity));
            }
            return context.getCapturedEntities().add(entity);
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            context.addNotifierAndOwnerToCauseStack(frame);
            frame.pushCause(tickingEntity);
            if (entity instanceof EntityXPOrb) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                this.appendContextOfPossibleEntityDeath(tickingEntity, frame);
                ArrayList<org.spongepowered.api.entity.Entity> experience = new ArrayList<org.spongepowered.api.entity.Entity>(1);
                experience.add(entity);
                boolean bl = SpongeCommonEventFactory.callSpawnEntity(experience, context);
                return bl;
            }
            if (tickingEntity instanceof Ageable && tickingEntity.getClass() == entity.getClass()) {
                EntityPlayerMP playerInLove;
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BREEDING);
                if (tickingEntity instanceof EntityAnimal && (playerInLove = ((EntityAnimal)tickingEntity).func_191993_do()) != null) {
                    frame.addContext(EventContextKeys.PLAYER, (Player)playerInLove);
                }
                ArrayList<org.spongepowered.api.entity.Entity> breeding = new ArrayList<org.spongepowered.api.entity.Entity>(1);
                breeding.add(entity);
                boolean bl = SpongeCommonEventFactory.callSpawnEntity(breeding, context);
                return bl;
            }
            if (entity instanceof Projectile) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PROJECTILE);
                ArrayList<org.spongepowered.api.entity.Entity> projectile = new ArrayList<org.spongepowered.api.entity.Entity>(1);
                projectile.add(entity);
                boolean bl = SpongeCommonEventFactory.callSpawnEntity(projectile, context);
                return bl;
            }
            ArrayList<org.spongepowered.api.entity.Entity> nonExp = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            nonExp.add(entity);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PASSIVE);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(nonExp, context);
            return bl;
        }
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public boolean alreadyProcessingBlockItemDrops() {
        return true;
    }

    @Override
    public boolean doesBulkBlockCapture(EntityTickContext context) {
        return context.allowsBulkBlockCaptures();
    }

    @Override
    public boolean doesBlockEventTracking(EntityTickContext context) {
        return context.allowsBlockEvents();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

