/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import net.minecraft.entity.item.EntityXPOrb;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.NeighborNotificationContext;

class NeighborNotificationState
extends LocationBasedTickPhaseState<NeighborNotificationContext> {
    private final String name;

    NeighborNotificationState(String name) {
        this.name = name;
    }

    @Override
    public NeighborNotificationContext createPhaseContext() {
        return (NeighborNotificationContext)new NeighborNotificationContext(this).addCaptures();
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
    }

    @Override
    public void unwind(NeighborNotificationContext context) {
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, NeighborNotificationContext context) {
        context.getOwner().ifPresent(explosionContext::owner);
        context.getNotifier().ifPresent(explosionContext::notifier);
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        explosionContext.source(locatableBlock);
    }

    @Override
    public boolean spawnEntityOrCapture(NeighborNotificationContext context, Entity entity, int chunkX, int chunkZ) {
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        if (!context.allowsEntityEvents() || !ShouldFire.SPAWN_ENTITY_EVENT) {
            return EntityUtil.processEntitySpawn(entity, EntityUtil.ENTITY_CREATOR_FUNCTION.apply(context));
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(locatableBlock);
            this.associateAdditionalCauses(context, frame);
            if (entity instanceof EntityXPOrb) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                ArrayList<Entity> entities = new ArrayList<Entity>(1);
                entities.add(entity);
                boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
                return bl;
            }
            ArrayList<Entity> nonExpEntities = new ArrayList<Entity>(1);
            nonExpEntities.add(entity);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(nonExpEntities, context);
            return bl;
        }
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public boolean isNotReEntrant() {
        return false;
    }

    @Override
    public void postTrackBlock(BlockSnapshot snapshot, NeighborNotificationContext context) {
    }

    @Override
    public boolean doesBulkBlockCapture(NeighborNotificationContext context) {
        return false;
    }

    @Override
    public boolean doesBlockEventTracking(NeighborNotificationContext context) {
        return context.allowsBlockEvents();
    }

    @Override
    public boolean doesCaptureEntityDrops(NeighborNotificationContext context) {
        return false;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

