/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhaseState;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

abstract class TickPhaseState<C extends TickContext<C>>
implements IPhaseState<C> {
    private final String className = this.getClass().getSimpleName();

    TickPhaseState() {
    }

    @Override
    public final TrackingPhase getPhase() {
        return TrackingPhases.TICK;
    }

    @Override
    public boolean canSwitchTo(IPhaseState<?> state) {
        return state instanceof BlockPhaseState || state instanceof EntityPhaseState || state == GenerationPhase.State.TERRAIN_GENERATION;
    }

    @Override
    public boolean doesCaptureEntityDrops(C context) {
        return true;
    }

    @Override
    public boolean tracksBlockSpecificDrops(C context) {
        return true;
    }

    @Override
    public boolean isTicking() {
        return true;
    }

    @Override
    public void unwind(C phaseContext) {
    }

    @Override
    public void associateNeighborStateNotifier(C context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
    }

    @Override
    public void appendNotifierPreBlockTick(IMixinWorldServer mixinWorld, BlockPos pos, C context, BlockTickContext phaseContext) {
        if (this == TickPhase.Tick.BLOCK || this == TickPhase.Tick.RANDOM_BLOCK) {
            // empty if block
        }
    }

    @Override
    public void postProcessSpawns(C phaseContext, ArrayList<Entity> entities) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            if (!frame.getCurrentContext().get(EventContextKeys.SPAWN_TYPE).isPresent()) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
            }
            SpongeCommonEventFactory.callSpawnEntity(entities, phaseContext);
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, C context) {
    }

    @Override
    public abstract boolean spawnEntityOrCapture(C var1, Entity var2, int var3, int var4);

    public String toString() {
        return this.getPhase() + "{" + this.className + "}";
    }
}

