/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntity;

class TileEntityTickPhaseState
extends LocationBasedTickPhaseState<TileEntityTickContext> {
    private String name;

    TileEntityTickPhaseState(String name) {
        this.name = name;
    }

    @Override
    public TileEntityTickContext createPhaseContext() {
        return (TileEntityTickContext)((TileEntityTickContext)((TileEntityTickContext)new TileEntityTickContext(this).addEntityCaptures()).addEntityDropCaptures()).addBlockCaptures();
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }

    @Override
    public boolean doesCaptureEntityDrops(TileEntityTickContext context) {
        return true;
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over a TileEntity!", context)).getLocatableBlock();
    }

    @Override
    public void unwind(TileEntityTickContext context) {
        TileEntity tickingTile = context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", context));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, context));
            frame.pushCause(tickingTile.getLocatableBlock());
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
                ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem entity : entities) {
                    capturedEntities.add(EntityUtil.fromNative((Entity)entity));
                }
                SpongeCommonEventFactory.callSpawnEntity(capturedEntities, context);
            });
            frame.removeContext(EventContextKeys.SPAWN_TYPE);
            context.getPerEntityItemEntityDropSupplier().acceptAndClearIfNotEmpty((id, item) -> {
                frame.popCause();
                ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
                entities.add(EntityUtil.fromNative((Entity)item));
                Optional<org.spongepowered.api.entity.Entity> entity = tickingTile.getWorld().getEntity((UUID)id);
                if (!entity.isPresent()) {
                    frame.pushCause(tickingTile);
                    frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
                    SpongeCommonEventFactory.callSpawnEntity(entities, context);
                    return;
                }
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                org.spongepowered.api.entity.Entity nestedEntity = entity.get();
                frame.pushCause(nestedEntity);
                frame.pushCause(tickingTile);
                SpongeCommonEventFactory.callSpawnEntityCustom(entities, context);
                EntityUtil.toMixin(nestedEntity).clearWrappedCaptureList();
            });
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception occurred while processing tile entity %s at %s", tickingTile, tickingTile.getLocation()), e);
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, TileEntityTickContext context) {
        context.getOwner().ifPresent(explosionContext::owner);
        context.getNotifier().ifPresent(explosionContext::notifier);
        TileEntity tickingTile = context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking TileEntity!", context));
        explosionContext.source(tickingTile);
    }

    @Override
    public boolean spawnEntityOrCapture(TileEntityTickContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        TileEntity tickingTile = context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", context));
        IMixinTileEntity mixinTileEntity = (IMixinTileEntity)((Object)tickingTile);
        if (!context.allowsEntityEvents() || !ShouldFire.SPAWN_ENTITY_EVENT) {
            return EntityUtil.processEntitySpawn(entity, EntityUtil.ENTITY_CREATOR_FUNCTION.apply(context));
        }
        if (entity instanceof EntityXPOrb) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(tickingTile.getLocatableBlock());
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                context.addNotifierAndOwnerToCauseStack(frame);
                ArrayList<org.spongepowered.api.entity.Entity> exp = new ArrayList<org.spongepowered.api.entity.Entity>();
                exp.add(entity);
                boolean bl = SpongeCommonEventFactory.callSpawnEntity(exp, context);
                return bl;
            }
        }
        ArrayList<org.spongepowered.api.entity.Entity> nonExpEntities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
        nonExpEntities.add(entity);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(tickingTile.getLocatableBlock());
            frame.addContext(EventContextKeys.SPAWN_TYPE, mixinTileEntity.getTickedSpawnType());
            context.addNotifierAndOwnerToCauseStack(frame);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(nonExpEntities, context);
            return bl;
        }
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public boolean doesBulkBlockCapture(TileEntityTickContext context) {
        return context.allowsBulkBlockCaptures();
    }

    @Override
    public boolean doesBlockEventTracking(TileEntityTickContext context) {
        return context.allowsBlockEvents();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

