/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.data.util.DataQueries;

public class SpongeFireworkEffect
implements FireworkEffect {
    private final boolean flicker;
    private final boolean trails;
    private final ImmutableList<Color> colors;
    private final ImmutableList<Color> fades;
    private final FireworkShape shape;

    SpongeFireworkEffect(boolean flicker, boolean trails, Iterable<Color> colors, Iterable<Color> fades, FireworkShape shape) {
        this.flicker = flicker;
        this.trails = trails;
        this.colors = ImmutableList.copyOf(colors);
        this.fades = ImmutableList.copyOf(fades);
        this.shape = shape;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeFireworkEffect that = (SpongeFireworkEffect)o;
        return this.flicker == that.flicker && this.trails == that.trails && Objects.equals(this.colors, that.colors) && Objects.equals(this.fades, that.fades) && Objects.equals(this.shape, that.shape);
    }

    public int hashCode() {
        return Objects.hash(this.flicker, this.trails, this.colors, this.fades, this.shape);
    }

    @Override
    public boolean flickers() {
        return this.flicker;
    }

    @Override
    public boolean hasTrail() {
        return this.trails;
    }

    @Override
    public List<Color> getColors() {
        return this.colors;
    }

    @Override
    public List<Color> getFadeColors() {
        return this.fades;
    }

    @Override
    public FireworkShape getShape() {
        return this.shape;
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(DataQueries.FIREWORK_SHAPE, (Object)this.shape.getId()).set(DataQueries.FIREWORK_COLORS, this.colors).set(DataQueries.FIREWORK_FADE_COLORS, this.fades).set(DataQueries.FIREWORK_TRAILS, (Object)this.trails).set(DataQueries.FIREWORK_FLICKERS, (Object)this.flicker);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("shape", (Object)this.shape).add("trails", this.trails).add("flickers", this.flicker).add("colors", this.colors).add("fades", this.fades).toString();
    }
}

