/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.EmptyInventory;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.text.translation.SpongeTranslation;

public class EmptyInventoryImpl
implements EmptyInventory {
    public static final Translation EMPTY_NAME = new SpongeTranslation("inventory.empty.title");
    private final Inventory parent;

    public EmptyInventoryImpl(Inventory parent) {
        this.parent = parent;
    }

    @Override
    public <T extends Inventory> Iterable<T> slots() {
        return Collections.emptyList();
    }

    @Override
    public <T extends Inventory> T first() {
        return (T)this;
    }

    @Override
    public Optional<ItemStack> poll() {
        return Optional.empty();
    }

    @Override
    public Optional<ItemStack> poll(int limit) {
        return Optional.empty();
    }

    @Override
    public Optional<ItemStack> peek() {
        return Optional.empty();
    }

    @Override
    public Optional<ItemStack> peek(int limit) {
        return Optional.empty();
    }

    @Override
    public void clear() {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int totalItems() {
        return 0;
    }

    @Override
    public int capacity() {
        return 0;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean contains(ItemStack stack) {
        return false;
    }

    @Override
    public boolean containsAny(ItemStack stack) {
        return false;
    }

    @Override
    public boolean contains(ItemType type) {
        return false;
    }

    @Override
    public int getMaxStackSize() {
        return 0;
    }

    @Override
    public void setMaxStackSize(int size) {
    }

    @Override
    public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Inventory child, Class<T> property) {
        return Collections.emptyList();
    }

    @Override
    public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Class<T> property) {
        return Collections.emptyList();
    }

    @Override
    public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Inventory child, Class<T> property, Object key) {
        return Optional.empty();
    }

    @Override
    public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Class<T> property, Object key) {
        return Optional.empty();
    }

    @Override
    public <T extends InventoryProperty<?, ?>> Optional<T> getInventoryProperty(Inventory child, Class<T> property) {
        return Optional.empty();
    }

    @Override
    public <T extends InventoryProperty<?, ?>> Optional<T> getInventoryProperty(Class<T> property) {
        return Optional.empty();
    }

    @Override
    public <T extends Inventory> T query(QueryOperation<?> ... operations) {
        return (T)this;
    }

    @Override
    public Inventory intersect(Inventory inventory) {
        return this;
    }

    @Override
    public Inventory union(Inventory inventory) {
        return inventory;
    }

    @Override
    public boolean containsInventory(Inventory inventory) {
        return this == inventory;
    }

    @Override
    public Iterator<Inventory> iterator() {
        return new EmptyIterator();
    }

    @Override
    public Inventory parent() {
        return this.parent;
    }

    @Override
    public Inventory root() {
        return this.parent == this ? this : this.parent.root();
    }

    @Override
    public <T extends Inventory> T next() {
        return (T)this;
    }

    @Override
    public InventoryTransactionResult offer(ItemStack stack) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).reject(stack).build();
    }

    @Override
    public InventoryTransactionResult set(ItemStack stack) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).reject(stack).build();
    }

    @Override
    public Translation getName() {
        return EMPTY_NAME;
    }

    @Override
    public PluginContainer getPlugin() {
        return this.parent.getPlugin();
    }

    @Override
    public InventoryArchetype getArchetype() {
        return InventoryArchetypes.UNKNOWN;
    }

    static final class EmptyIterator
    implements Iterator<Inventory> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Inventory next() {
            throw new NoSuchElementException("Attempted to iterate over an empty Inventory");
        }

        @Override
        public void remove() {
            throw new NoSuchElementException("Attempted to remove an element from an empty collection");
        }
    }
}

