/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;

public class ReusableLens<T extends Lens> {
    private static Map<Class<? extends InventoryAdapter>, Map<Class<? extends Lens>, Int2ObjectMap<ReusableLens>>> reusableLenses = new HashMap<Class<? extends InventoryAdapter>, Map<Class<? extends Lens>, Int2ObjectMap<ReusableLens>>>();
    private final SlotProvider slots;
    private final T lens;

    public ReusableLens(SlotProvider slots, T lens) {
        this.slots = slots;
        this.lens = lens;
    }

    public ReusableLens(SlotProvider slots, Function<SlotProvider, T> lensProvider) {
        this.slots = slots;
        this.lens = (Lens)lensProvider.apply(slots);
    }

    public static <T extends Lens> ReusableLens<T> getLens(Class<T> lensType, InventoryAdapter adapter, Supplier<SlotProvider> slots, Function<SlotProvider, T> lens) {
        Map adapterLenses = reusableLenses.computeIfAbsent(adapter.getClass(), k -> new HashMap());
        Int2ObjectMap lenses = adapterLenses.computeIfAbsent(lensType, k -> new Int2ObjectOpenHashMap());
        return (ReusableLens)lenses.computeIfAbsent((Object)adapter.getFabric().getSize(), k -> {
            SlotProvider sl = (SlotProvider)slots.get();
            return new ReusableLens(sl, lens);
        });
    }

    public SlotProvider getSlots() {
        return this.slots;
    }

    public T getLens() {
        return this.lens;
    }
}

