/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.comp;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.OrderedInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.OrderedInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.ConceptualLens;
import org.spongepowered.common.item.inventory.lens.impl.struct.LensHandle;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class OrderedInventoryLensImpl
extends ConceptualLens
implements OrderedInventoryLens {
    protected final int stride;
    protected final List<LensHandle> slotCache = new ArrayList<LensHandle>();

    public OrderedInventoryLensImpl(int base, int size, int stride, SlotProvider slots) {
        this(base, size, stride, OrderedInventoryAdapter.class, slots);
    }

    public OrderedInventoryLensImpl(int base, int size, int stride, Class<? extends Inventory> adapterType, SlotProvider slots) {
        super(base, size, adapterType, slots);
        Preconditions.checkArgument((stride > 0 ? 1 : 0) != 0, (String)"Invalid stride: %s", (int)stride);
        this.stride = stride;
        this.init(slots);
    }

    protected void cache() {
        for (LensHandle child : this.spanningChildren) {
            this.cache0(child.lens);
        }
    }

    private void cache0(Lens lens) {
        if (lens instanceof SlotLens) {
            this.slotCache.add(new LensHandle(lens, lens.getProperties(0)));
            return;
        }
        for (Lens child : lens.getSpanningChildren()) {
            if (child instanceof SlotLens) {
                this.slotCache.add(new LensHandle(child, lens.getProperties(child)));
                continue;
            }
            this.cache0(child);
        }
    }

    @Override
    public int getStride() {
        return this.stride;
    }

    @Override
    public SlotLens getSlot(int ordinal) {
        return (SlotLens)this.slotCache.get((int)ordinal).lens;
    }

    @Override
    protected void init(SlotProvider slots) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            this.addSpanningChild(slots.getSlot(slot), new SlotIndex(ord));
            ++ord;
            slot += this.stride;
        }
        this.cache();
    }

    @Override
    public int getRealIndex(Fabric inv, int ordinal) {
        if (!this.checkOrdinal(ordinal)) {
            return -1;
        }
        return this.base + ordinal * this.stride;
    }

    @Override
    public boolean hasSlotRealIndex(int index) {
        return this.availableSlots.contains(this.base + index);
    }

    @Override
    public InventoryAdapter getAdapter(Fabric inv, Inventory parent) {
        return new OrderedInventoryAdapter(inv, this, parent);
    }
}

