/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.fabric;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.text.translation.FixedTranslation;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftFabric;

public class ContainerFabric
extends MinecraftFabric {
    private Translation displayName;
    private final Container container;
    private final Set<IInventory> all;

    public ContainerFabric(Container container) {
        this(ContainerFabric.getFirstDisplayName(container), container);
    }

    private ContainerFabric(Translation displayName, Container container) {
        this.displayName = displayName;
        this.container = container;
        List slots = this.container.field_75151_b;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Slot slot : slots) {
            if (slot.field_75224_c == null) continue;
            builder.add((Object)slot.field_75224_c);
        }
        this.all = builder.build();
    }

    @Override
    public Collection<?> allInventories() {
        return this.all;
    }

    public IInventory get(int index) {
        return this.container.func_75139_a((int)index).field_75224_c;
    }

    @Override
    public ItemStack getStack(int index) {
        return this.container.func_75139_a(index).func_75211_c();
    }

    @Override
    public void setStack(int index, ItemStack stack) {
        this.container.func_75139_a(index).func_75215_d(stack);
    }

    @Override
    public int getMaxStackSize() {
        int max = 0;
        for (IInventory inv : this.all) {
            max = Math.max(max, inv.func_70297_j_());
        }
        return max;
    }

    @Override
    public Translation getDisplayName() {
        return this.displayName;
    }

    @Override
    public int getSize() {
        return this.container.field_75151_b.size();
    }

    @Override
    public void clear() {
        this.all.forEach(IInventory::func_174888_l);
    }

    @Override
    public void markDirty() {
        this.container.func_75142_b();
    }

    static Translation getFirstDisplayName(Container container) {
        if (container.field_75151_b.size() == 0) {
            return new FixedTranslation("Container");
        }
        try {
            Slot slot = container.func_75139_a(0);
            return slot.field_75224_c != null && slot.field_75224_c.func_145748_c_() != null ? new FixedTranslation(slot.field_75224_c.func_145748_c_().func_150260_c()) : new FixedTranslation("UNKNOWN: " + container.getClass().getName());
        }
        catch (AbstractMethodError e) {
            SpongeImpl.getLogger().warn("AbstractMethodError! Could not find displayName for " + container.func_75139_a((int)0).field_75224_c.getClass().getName(), (Throwable)e);
            return new FixedTranslation("UNKNOWN: " + container.getClass().getName());
        }
    }

    public Container getContainer() {
        return this.container;
    }
}

