/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.minecraft.container;

import java.util.Collections;
import java.util.List;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.RealLens;

public class ContainerLens
extends RealLens {
    protected List<Lens> viewedInventories;
    private List<Lens> additonal = Collections.emptyList();

    public ContainerLens(InventoryAdapter adapter, SlotProvider slots, List<Lens> lenses) {
        this(adapter, slots, lenses, Collections.emptyList());
    }

    public ContainerLens(InventoryAdapter adapter, SlotProvider slots, List<Lens> lenses, List<Lens> additonal) {
        this(adapter, slots);
        this.viewedInventories = lenses;
        this.additonal = additonal;
        this.init(slots);
    }

    public ContainerLens(InventoryAdapter adapter, SlotProvider slots) {
        super(0, adapter.getFabric().getSize(), adapter, slots);
    }

    @Override
    protected void init(SlotProvider slots) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            this.addChild(slots.getSlot(slot), new SlotIndex(ord));
            ++ord;
            ++slot;
        }
        for (Lens lens : this.viewedInventories) {
            this.addSpanningChild(lens, new InventoryProperty[0]);
        }
        for (Lens lens : this.additonal) {
            this.addChild(lens, new InventoryProperty[0]);
        }
    }
}

