/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smelting;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipe;
import org.spongepowered.common.item.recipe.smelting.MatchSmeltingVanillaItemStack;
import org.spongepowered.common.item.recipe.smelting.SpongeSmeltingRecipe;

public class SpongeSmeltingRecipeBuilder
implements SmeltingRecipe.Builder.ResultStep,
SmeltingRecipe.Builder.EndStep {
    private ItemStackSnapshot exemplaryResult;
    private ItemStackSnapshot exemplaryIngredient;
    private Predicate<ItemStackSnapshot> ingredientPredicate;
    private double experience;

    @Override
    public SmeltingRecipe.Builder from(SmeltingRecipe value) {
        Preconditions.checkNotNull((Object)value, (Object)"value");
        this.exemplaryResult = value.getExemplaryResult();
        this.exemplaryIngredient = value.getExemplaryIngredient();
        this.experience = 0.0;
        return this;
    }

    @Override
    public SmeltingRecipe.Builder reset() {
        this.exemplaryResult = null;
        this.exemplaryIngredient = null;
        this.experience = 0.0;
        return this;
    }

    @Override
    public SmeltingRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        Preconditions.checkNotNull((Object)result, (Object)"result");
        Preconditions.checkArgument((result != ItemStackSnapshot.NONE ? 1 : 0) != 0, (Object)"The result must not be ItemStackSnapshot.NONE.");
        this.exemplaryResult = result;
        return this;
    }

    @Override
    public SmeltingRecipe.Builder.ResultStep ingredient(Predicate<ItemStackSnapshot> ingredientPredicate, ItemStackSnapshot exemplaryIngredient) {
        Preconditions.checkNotNull(ingredientPredicate, (Object)"ingredientPredicate");
        Preconditions.checkNotNull((Object)exemplaryIngredient, (Object)"exemplaryIngredient");
        Preconditions.checkArgument((exemplaryIngredient != ItemStackSnapshot.NONE ? 1 : 0) != 0, (Object)"The ingredient must not be ItemStackSnapshot.NONE.");
        Preconditions.checkState((boolean)ingredientPredicate.test(exemplaryIngredient), (Object)"The ingredient predicate does not allow the specified exemplary ingredient.");
        this.ingredientPredicate = ingredientPredicate;
        this.exemplaryIngredient = exemplaryIngredient;
        return this;
    }

    @Override
    public SmeltingRecipe.Builder.ResultStep ingredient(ItemStackSnapshot ingredient) {
        Preconditions.checkNotNull((Object)ingredient, (Object)"ingredient");
        return this.ingredient(new MatchSmeltingVanillaItemStack(ingredient), ingredient);
    }

    @Override
    public SmeltingRecipe.Builder.EndStep experience(double experience) {
        Preconditions.checkState((experience >= 0.0 ? 1 : 0) != 0, (Object)"The experience must be non-negative.");
        this.experience = experience;
        return this;
    }

    @Override
    public SmeltingRecipe build() {
        Preconditions.checkState((this.exemplaryResult != null && this.exemplaryResult != ItemStackSnapshot.NONE ? 1 : 0) != 0, (Object)"The result must be specified.");
        Preconditions.checkState((this.exemplaryIngredient != null && this.exemplaryIngredient != ItemStackSnapshot.NONE ? 1 : 0) != 0, (Object)"The ingredient must be specified.");
        Preconditions.checkState((this.ingredientPredicate != null ? 1 : 0) != 0, (Object)"You must specify the ingredient predicate.");
        Preconditions.checkState((boolean)this.ingredientPredicate.test(this.exemplaryIngredient), (Object)"The ingredient predicate does not allow the specified exemplary ingredient.");
        Preconditions.checkState((this.experience >= 0.0 ? 1 : 0) != 0, (Object)"The experience must be non-negative.");
        return new SpongeSmeltingRecipe(this.exemplaryResult, this.exemplaryIngredient, this.ingredientPredicate, this.experience);
    }
}

